/*
 * Decompiled with CFR 0.152.
 */
package net.technicpack.ui.controls.borders;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import javax.swing.border.AbstractBorder;
import net.technicpack.contrib.romainguy.FastBlurFilter;

public class DropShadowBorder
extends AbstractBorder {
    private Color color;
    private int thickness;
    private Insets insets;
    RenderingHints hints;

    public DropShadowBorder(Color color) {
        this(color, 3);
    }

    public DropShadowBorder(Color color, int thickness) {
        this.thickness = thickness;
        this.color = color;
        this.hints = new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        this.insets = new Insets(thickness * 4, thickness * 4, thickness * 4, thickness * 4);
    }

    @Override
    public Insets getBorderInsets(Component c) {
        return this.insets;
    }

    @Override
    public Insets getBorderInsets(Component c, Insets insets) {
        return this.getBorderInsets(c);
    }

    @Override
    public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
        BufferedImage shadow = new BufferedImage(width, height, 2);
        Graphics2D g2 = shadow.createGraphics();
        g2.setRenderingHints(this.hints);
        Composite oldComposite = g2.getComposite();
        AlphaComposite composite = AlphaComposite.getInstance(1, 0.0f);
        g2.setComposite(composite);
        g2.setColor(new Color(0, 0, 0, 0));
        g2.fillRect(0, 0, width, height);
        g2.setComposite(oldComposite);
        g2.setColor(this.color);
        g2.fillRect(this.thickness * 4, this.thickness * 4, width - this.thickness * 8, height - this.thickness * 8);
        g2.dispose();
        FastBlurFilter blur = new FastBlurFilter(this.thickness);
        shadow = blur.filter(shadow, null);
        shadow = blur.filter(shadow, null);
        shadow = blur.filter(shadow, null);
        shadow = blur.filter(shadow, null);
        g.drawImage(shadow, x, y, width, height, null);
    }
}

