/*
 * Decompiled with CFR 0.152.
 */
package net.technicpack.ui.controls.borders;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.Area;
import java.awt.geom.RoundRectangle2D;
import javax.swing.border.AbstractBorder;

public class RoundBorder
extends AbstractBorder {
    private Color color;
    private int thickness;
    private int radii;
    private Insets insets;
    private BasicStroke stroke;
    private int strokePad;
    RenderingHints hints;

    public RoundBorder(Color color) {
        this(color, 4, 8);
    }

    public RoundBorder(Color color, int thickness, int radii) {
        this.thickness = thickness;
        this.radii = radii;
        this.color = color;
        this.stroke = new BasicStroke(thickness);
        this.strokePad = thickness / 2;
        this.hints = new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        int pad = this.strokePad;
        int bottomPad = Math.max(pad + this.strokePad, 1);
        int radiusBounds = Math.max(pad + radii / 2, 1);
        this.insets = new Insets(pad, radiusBounds, bottomPad, radiusBounds);
    }

    @Override
    public Insets getBorderInsets(Component c) {
        return this.insets;
    }

    @Override
    public Insets getBorderInsets(Component c, Insets insets) {
        return this.getBorderInsets(c);
    }

    @Override
    public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
        Graphics2D g2 = (Graphics2D)g;
        int bottomLineY = height - this.thickness;
        RoundRectangle2D.Double bubble = new RoundRectangle2D.Double(0 + this.strokePad, 0 + this.strokePad, width - this.thickness - 1, bottomLineY, this.radii, this.radii);
        Polygon pointer = new Polygon();
        Area area = new Area(bubble);
        area.add(new Area(pointer));
        g2.setRenderingHints(this.hints);
        Container parent = c.getParent();
        if (parent != null) {
            Color bg = parent.getBackground();
            Rectangle rect = new Rectangle(0, 0, width, height);
            Area borderRegion = new Area(rect);
            borderRegion.subtract(area);
            Shape oldClip = g2.getClip();
            g2.clip(borderRegion);
            g2.setColor(bg);
            g2.fillRect(0, 0, width, height);
            g2.setClip(null);
        }
        g2.setColor(this.color);
        g2.setStroke(this.stroke);
        g2.draw(area);
    }
}

