/*
 * Decompiled with CFR 0.152.
 */
package net.technicpack.ui.controls.feeds;

import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.Rectangle2D;
import javax.swing.JComponent;

public class CountCircle
extends JComponent {
    private int count;

    public CountCircle() {
        this.setVisible(false);
    }

    public int getCount() {
        return this.count;
    }

    public void setCount(int count) {
        if (count < 0) {
            count = 0;
        }
        this.count = count;
        this.setVisible(count > 0);
    }

    public String getText() {
        if (this.count > 9) {
            return "!";
        }
        return Integer.toString(this.count);
    }

    @Override
    public void paint(Graphics g) {
        Graphics2D g2d = (Graphics2D)g;
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2d.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_LCD_HRGB);
        g2d.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
        String text = this.getText();
        g2d.setFont(this.getFont());
        Rectangle2D bounds = g2d.getFontMetrics().getStringBounds(text, g2d);
        double radius = Math.max(bounds.getWidth(), bounds.getHeight());
        int size = (int)Math.ceil(radius);
        g2d.setColor(this.getBackground());
        g2d.fillOval(0, 0, size, size);
        g2d.setColor(this.getForeground());
        g2d.drawString(text, size / 2 - (int)(0.5 + bounds.getWidth() / 2.0), size / 2 - (int)(0.5 + bounds.getY() + bounds.getHeight() / 2.0));
    }
}

