/*
 * Decompiled with CFR 0.152.
 */
package net.technicpack.ui.controls.installation;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import net.technicpack.ui.controls.installation.ProgressBar;
import net.technicpack.utilslib.Utils;

public class SplashScreen
extends JFrame {
    protected final ImageIcon image;
    private ProgressBar progressBar = null;

    public SplashScreen(Image img, int barHeight) {
        this.setUndecorated(true);
        this.setTitle("Technic Launcher");
        this.image = new ImageIcon(img);
        Container container = this.getContentPane();
        container.setLayout(new BorderLayout());
        BufferedImage alphaImage = new BufferedImage(this.image.getIconWidth(), this.image.getIconHeight(), 2);
        Graphics2D g = alphaImage.createGraphics();
        g.drawImage(img, 0, 0, this.image.getIconWidth(), this.image.getIconHeight(), null);
        g.dispose();
        JButton background = new JButton(new ImageIcon(alphaImage));
        background.setRolloverEnabled(true);
        background.setRolloverIcon(background.getIcon());
        background.setSelectedIcon(background.getIcon());
        background.setDisabledIcon(background.getIcon());
        background.setPressedIcon(background.getIcon());
        background.setFocusable(false);
        background.setContentAreaFilled(false);
        background.setBorderPainted(false);
        background.setOpaque(false);
        container.add((Component)background, "Center");
        if (barHeight > 0) {
            JPanel panel = new JPanel();
            panel.setOpaque(false);
            container.add((Component)panel, "South");
            panel.setLayout(new BorderLayout());
            JPanel progressPanel = new JPanel();
            progressPanel.setOpaque(false);
            progressPanel.setLayout(new BoxLayout(progressPanel, 3));
            panel.add((Component)progressPanel, "Center");
            panel.add(Box.createVerticalStrut(barHeight + barHeight - 5), "East");
            this.progressBar = new ProgressBar();
            progressPanel.add(Box.createVerticalStrut(barHeight - 5));
            progressPanel.add(this.progressBar);
        }
        this.getRootPane().setOpaque(false);
        try {
            this.setBackground(new Color(0, 0, 0, 0));
        }
        catch (UnsupportedOperationException ex) {
            this.setBackground(new Color(0, 0, 0));
        }
        catch (IllegalArgumentException ex) {
            Utils.getLogger().warning("Your desktop environment does not support translucent windows. Technic Launcher will not look as rad for you.");
        }
    }

    public ProgressBar getProgressBar() {
        return this.progressBar;
    }
}

