/*
 * Decompiled with CFR 0.152.
 */
package net.technicpack.utilslib;

import com.sun.management.OperatingSystemMXBean;
import java.lang.management.ManagementFactory;
import java.util.logging.Level;
import net.technicpack.utilslib.Utils;

public class Memory {
    public static final Memory[] memoryOptions = new Memory[]{new Memory(512, "512 MB", 1), new Memory(768, "768 MB", 2), new Memory(1024, "1 GB", 3), new Memory(1536, "1.5 GB", 4), new Memory(2048, "2 GB", 5), new Memory(2560, "2.5 GB", 19), new Memory(3072, "3 GB", 0), new Memory(3584, "3.5 GB", 20), new Memory(4096, "4 GB", 6), new Memory(5120, "5 GB", 7), new Memory(6144, "6 GB", 8), new Memory(7168, "7 GB", 9), new Memory(8192, "8 GB", 10), new Memory(9216, "9 GB", 11), new Memory(10240, "10 GB", 12), new Memory(11264, "11 GB", 13), new Memory(12288, "12 GB", 14), new Memory(13312, "13 GB", 15), new Memory(14336, "14 GB", 16), new Memory(15360, "15 GB", 17), new Memory(16384, "16 GB", 18), new Memory(17408, "17 GB", 21), new Memory(18432, "18 GB", 22), new Memory(19456, "19 GB", 23), new Memory(20480, "20 GB", 24), new Memory(21504, "21 GB", 25), new Memory(22528, "22 GB", 26), new Memory(23552, "23 GB", 27), new Memory(24576, "24 GB", 28), new Memory(25600, "25 GB", 29), new Memory(26624, "26 GB", 30), new Memory(27648, "27 GB", 31), new Memory(28672, "28 GB", 32), new Memory(29696, "29 GB", 33), new Memory(30720, "30 GB", 34), new Memory(31744, "31 GB", 35), new Memory(31768, "32 GB", 36)};
    public static final Memory DEFAULT_MEM = memoryOptions[2];
    public static final int MAX_32_BIT_MEMORY = 1024;
    long memory;
    String text;
    int option;

    public static long getPhysicalMemory() {
        long maxMemory = 0L;
        try {
            java.lang.management.OperatingSystemMXBean osInfo = ManagementFactory.getOperatingSystemMXBean();
            if (osInfo instanceof OperatingSystemMXBean) {
                maxMemory = ((OperatingSystemMXBean)osInfo).getTotalPhysicalMemorySize() / 1024L / 1024L;
            } else {
                Utils.getLogger().log(Level.SEVERE, "Failed to detect physical memory: incorrect instance type " + osInfo.getClass().getName());
            }
        }
        catch (Throwable t) {
            Utils.getLogger().log(Level.SEVERE, "Failed to detect physical memory", t);
        }
        return Math.max(512L, maxMemory);
    }

    public static long getAvailableMemory(boolean is64Bit) {
        long physical = Memory.getPhysicalMemory();
        if (!is64Bit && physical > 1024L) {
            return 1024L;
        }
        return physical;
    }

    public static Memory getClosestAvailableMemory(Memory memory, boolean is64Bit) {
        long available = Memory.getAvailableMemory(is64Bit);
        if (memory.getMemoryMB() <= available) {
            return memory;
        }
        Memory bestMemory = memoryOptions[0];
        for (Memory option : memoryOptions) {
            if (option.getMemoryMB() > available || option.getMemoryMB() <= bestMemory.getMemoryMB()) continue;
            bestMemory = option;
        }
        return bestMemory;
    }

    private Memory(int memory, String text, int option) {
        this.memory = memory;
        this.text = text;
        this.option = option;
    }

    public long getMemoryMB() {
        return this.memory;
    }

    public String getDescription() {
        return this.text;
    }

    public int getSettingsId() {
        return this.option;
    }

    public static Memory getMemoryFromId(int id) {
        for (Memory m : memoryOptions) {
            if (m.getSettingsId() != id) continue;
            return m;
        }
        return DEFAULT_MEM;
    }

    public String toString() {
        return this.getDescription();
    }
}

