/*
 * Decompiled with CFR 0.152.
 */
package net.technicpack.utilslib;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.nio.channels.ClosedByInterruptException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.Collections;
import java.util.logging.Level;
import java.util.zip.ZipException;
import net.technicpack.launchercore.util.DownloadListener;
import net.technicpack.utilslib.IZipFileFilter;
import net.technicpack.utilslib.Utils;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipFile;

public class ZipUtils {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean extractFile(File zip, File output, String fileName) throws InterruptedException {
        if (!zip.exists()) return false;
        if (fileName == null) {
            return false;
        }
        try (ZipFile zipFile = ((ZipFile.Builder)ZipFile.builder().setFile(zip)).get();){
            ZipArchiveEntry entry = zipFile.getEntry(fileName);
            if (entry == null) {
                Utils.getLogger().log(Level.WARNING, "File " + fileName + " not found in " + zip.getAbsolutePath());
                boolean bl = false;
                return bl;
            }
            File outputFile = new File(output, entry.getName());
            if (!outputFile.toPath().normalize().startsWith(output.toPath())) {
                Utils.getLogger().log(Level.SEVERE, "Detected Zip Slip attempt on entry " + entry.getName() + " from " + zip.getAbsolutePath());
                boolean bl = false;
                return bl;
            }
            if (outputFile.getParentFile() != null) {
                outputFile.getParentFile().mkdirs();
            }
            ZipUtils.unzipEntry(zipFile, zipFile.getEntry(fileName), outputFile);
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            Utils.getLogger().log(Level.WARNING, "Error extracting file " + fileName + " from " + zip.getAbsolutePath());
            return false;
        }
    }

    private static void unzipEntry(ZipFile zipFile, ZipArchiveEntry entry, File outputFile) throws IOException, InterruptedException {
        byte[] buffer = new byte[2048];
        try (BufferedInputStream inputStream = new BufferedInputStream(zipFile.getInputStream(entry));
             BufferedOutputStream outputStream = new BufferedOutputStream(Files.newOutputStream(outputFile.toPath(), new OpenOption[0]));){
            int length;
            while ((length = inputStream.read(buffer, 0, buffer.length)) != -1) {
                outputStream.write(buffer, 0, length);
            }
        }
        catch (ClosedByInterruptException ex) {
            throw new InterruptedException();
        }
    }

    public static void unzipFile(File zip, File output, IZipFileFilter fileFilter, DownloadListener listener) throws IOException, InterruptedException {
        if (!zip.exists()) {
            Utils.getLogger().log(Level.SEVERE, "File to unzip does not exist: " + zip.getAbsolutePath());
            return;
        }
        if (!output.exists()) {
            output.mkdirs();
        }
        try (ZipFile zipFile = ((ZipFile.Builder)ZipFile.builder().setFile(zip)).get();){
            ArrayList<ZipArchiveEntry> entries = Collections.list(zipFile.getEntries());
            int totalEntries = entries.size();
            if (totalEntries == 0) {
                Utils.getLogger().log(Level.SEVERE, "Zip file is empty: " + zip.getAbsolutePath());
                zipFile.close();
                throw new ZipException("Zip file is empty: " + zip.getAbsolutePath());
            }
            int entriesDone = 0;
            for (ZipArchiveEntry entry : entries) {
                if (Thread.currentThread().isInterrupted()) {
                    throw new InterruptedException();
                }
                if (fileFilter == null || fileFilter.shouldExtract(entry.getName())) {
                    File outputFile = new File(output, entry.getName());
                    if (!outputFile.toPath().normalize().startsWith(output.toPath())) {
                        Utils.getLogger().log(Level.SEVERE, "Detected Zip Slip attempt on entry " + entry.getName() + " from " + zip.getAbsolutePath());
                        throw new IOException("Bad zip entry");
                    }
                    if (outputFile.exists() && outputFile.isFile() && !outputFile.canWrite()) {
                        if (outputFile.delete()) {
                            Utils.getLogger().log(Level.INFO, "Deleted non-writable file " + outputFile.getAbsolutePath());
                        } else {
                            throw new IOException("Failed to delete non-writable file " + outputFile.getAbsolutePath());
                        }
                    }
                    if (outputFile.getParentFile() != null) {
                        outputFile.getParentFile().mkdirs();
                    }
                    if (!entry.isDirectory()) {
                        ZipUtils.unzipEntry(zipFile, entry, outputFile);
                    }
                }
                if (listener != null) {
                    float totalProgress = (float)entriesDone / (float)totalEntries;
                    listener.stateChanged("Extracting " + entry.getName() + "...", totalProgress * 100.0f);
                }
                ++entriesDone;
            }
        }
    }
}

