/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.client.http.apache.v5;

import com.google.api.client.http.LowLevelHttpResponse;
import com.google.api.client.http.apache.v5.Apache5ResponseContent;
import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Logger;
import org.apache.hc.client5.http.classic.methods.HttpUriRequestBase;
import org.apache.hc.core5.http.ClassicHttpResponse;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.message.StatusLine;

final class Apache5HttpResponse
extends LowLevelHttpResponse {
    private static final Logger LOGGER = Logger.getLogger(Apache5HttpResponse.class.getName());
    private final HttpUriRequestBase request;
    private final ClassicHttpResponse response;
    private final Header[] allHeaders;
    private final HttpEntity entity;

    Apache5HttpResponse(HttpUriRequestBase request, ClassicHttpResponse response) {
        this.request = request;
        this.response = response;
        this.allHeaders = response.getHeaders();
        this.entity = response.getEntity();
    }

    @Override
    public int getStatusCode() {
        return this.response.getCode();
    }

    @Override
    public InputStream getContent() throws IOException {
        InputStream content = this.entity == null ? null : this.entity.getContent();
        return new Apache5ResponseContent(content, this.response);
    }

    @Override
    public String getContentEncoding() {
        return this.entity != null ? this.entity.getContentEncoding() : null;
    }

    @Override
    public long getContentLength() {
        return this.entity == null ? -1L : this.entity.getContentLength();
    }

    @Override
    public String getContentType() {
        return this.entity == null ? null : this.entity.getContentType();
    }

    @Override
    public String getReasonPhrase() {
        return this.response.getReasonPhrase();
    }

    @Override
    public String getStatusLine() {
        return new StatusLine(this.response).toString();
    }

    public String getHeaderValue(String name) {
        return this.response.getLastHeader(name).getValue();
    }

    @Override
    public int getHeaderCount() {
        return this.allHeaders.length;
    }

    @Override
    public String getHeaderName(int index) {
        return this.allHeaders[index].getName();
    }

    @Override
    public String getHeaderValue(int index) {
        return this.allHeaders[index].getValue();
    }

    @Override
    public void disconnect() throws IOException {
        this.request.abort();
        this.response.close();
    }
}

