/*
 * Decompiled with CFR 0.152.
 */
package net.technicpack.autoupdate.tasks;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.logging.Level;
import net.technicpack.autoupdate.Relauncher;
import net.technicpack.launchercore.install.InstallTasksQueue;
import net.technicpack.launchercore.install.tasks.IInstallTask;
import net.technicpack.utilslib.Utils;
import org.apache.commons.io.IOUtils;

public class MoveLauncherPackage
implements IInstallTask<Void> {
    private String description;
    private File launcher;
    private Relauncher relauncher;

    public MoveLauncherPackage(String description, File launcher, Relauncher relauncher) {
        this.description = description;
        this.launcher = launcher;
        this.relauncher = relauncher;
    }

    @Override
    public String getTaskDescription() {
        return this.description;
    }

    @Override
    public float getTaskProgress() {
        return 0.0f;
    }

    @Override
    public void runTask(InstallTasksQueue<Void> queue) {
        String currentPath = this.relauncher.getRunningPath();
        Utils.getLogger().log(Level.INFO, String.format("Moving running package from %s to %s", currentPath, this.launcher.getAbsolutePath()));
        File source = new File(currentPath);
        File dest = new File(this.launcher.getAbsolutePath());
        if (!source.equals(dest)) {
            if (dest.exists() && !dest.delete()) {
                Utils.getLogger().log(Level.SEVERE, "Deletion of existing package failed!");
            }
            try {
                if (!dest.getParentFile().exists()) {
                    dest.getParentFile().mkdirs();
                }
                dest.createNewFile();
                try (FileInputStream sourceStream = new FileInputStream(source);
                     FileOutputStream destStream = new FileOutputStream(dest);){
                    IOUtils.copy((InputStream)sourceStream, (OutputStream)destStream);
                }
            }
            catch (IOException ex) {
                Utils.getLogger().log(Level.SEVERE, "Error attempting to copy download package:", ex);
            }
        }
        dest.setExecutable(true, true);
    }
}

