/*
 * Decompiled with CFR 0.152.
 */
package net.technicpack.autoupdate.tasks;

import java.io.File;
import java.io.IOException;
import java.util.Collection;
import net.technicpack.autoupdate.IUpdateStream;
import net.technicpack.autoupdate.Relauncher;
import net.technicpack.autoupdate.io.LauncherResource;
import net.technicpack.autoupdate.io.StreamVersion;
import net.technicpack.autoupdate.tasks.DownloadUpdate;
import net.technicpack.launchercore.exception.DownloadException;
import net.technicpack.launchercore.install.ITasksQueue;
import net.technicpack.launchercore.install.InstallTasksQueue;
import net.technicpack.launchercore.install.LauncherDirectories;
import net.technicpack.launchercore.install.tasks.DownloadFileTask;
import net.technicpack.launchercore.install.tasks.IInstallTask;
import net.technicpack.launchercore.install.verifiers.IFileVerifier;
import net.technicpack.launchercore.install.verifiers.MD5FileVerifier;
import net.technicpack.launchercore.install.verifiers.SHA256FileVerifier;
import net.technicpack.rest.RestfulAPIException;

public class QueryUpdateStream
implements IInstallTask<Void> {
    private String description;
    private ITasksQueue<Void> downloadTasks;
    private IUpdateStream updateStream;
    private LauncherDirectories directories;
    private Relauncher relauncher;
    private Collection<IInstallTask<Void>> postDownloadTasks;

    public QueryUpdateStream(String description, IUpdateStream stream, ITasksQueue<Void> downloadTasks, LauncherDirectories directories, Relauncher relauncher, Collection<IInstallTask<Void>> postDownloadTasks) {
        this.description = description;
        this.downloadTasks = downloadTasks;
        this.updateStream = stream;
        this.directories = directories;
        this.relauncher = relauncher;
        this.postDownloadTasks = postDownloadTasks;
    }

    @Override
    public String getTaskDescription() {
        return this.description;
    }

    @Override
    public float getTaskProgress() {
        return 0.0f;
    }

    @Override
    public void runTask(InstallTasksQueue<Void> queue) throws IOException {
        try {
            StreamVersion version = this.updateStream.getStreamVersion(this.relauncher.getStreamName());
            if (version == null || version.getBuild() == 0) {
                return;
            }
            for (LauncherResource resource : version.getResources()) {
                DownloadFileTask downloadFileTask;
                IFileVerifier verifier = resource.getSha256() != null && !resource.getSha256().isEmpty() ? new SHA256FileVerifier(resource.getSha256()) : (resource.getMd5() != null && !resource.getMd5().isEmpty() ? new MD5FileVerifier(resource.getMd5()) : null);
                File targetFile = new File(new File(this.directories.getAssetsDirectory(), "launcher"), resource.getFilename());
                if (targetFile.exists() && verifier.isFileValid(targetFile)) continue;
                String zstdUrl = resource.getZstdUrl();
                if (zstdUrl != null && !zstdUrl.isEmpty()) {
                    downloadFileTask = new DownloadFileTask(zstdUrl, targetFile, verifier, resource.getFilename());
                    downloadFileTask.setDecompressor("zstd");
                } else {
                    downloadFileTask = new DownloadFileTask(resource.getUrl(), targetFile, verifier, resource.getFilename());
                }
                this.downloadTasks.addTask(downloadFileTask);
            }
            if (this.relauncher.isSkipUpdate() || version.getBuild() == this.relauncher.getCurrentBuild()) {
                return;
            }
            String runningPath = this.relauncher.getRunningPath();
            if (runningPath == null) {
                throw new DownloadException("Could not load a running path for currently-executing launcher.");
            }
            String updateUrl = runningPath.endsWith(".exe") ? version.getExeUrl() : version.getJarUrl();
            this.downloadTasks.addTask(new DownloadUpdate(updateUrl, this.relauncher, this.postDownloadTasks));
        }
        catch (RestfulAPIException restfulAPIException) {
            // empty catch block
        }
    }
}

