/*
 * Decompiled with CFR 0.152.
 */
package net.technicpack.launcher.io;

import java.awt.image.BufferedImage;
import java.io.File;
import net.technicpack.launchercore.auth.IUserType;
import net.technicpack.launchercore.image.IImageMapper;
import net.technicpack.launchercore.install.LauncherDirectories;
import net.technicpack.ui.lang.ResourceLoader;

public class TechnicFaceMapper
implements IImageMapper<IUserType> {
    private LauncherDirectories directories;
    private BufferedImage defaultImage;

    public TechnicFaceMapper(LauncherDirectories directories, ResourceLoader resources) {
        this.directories = directories;
        this.defaultImage = resources.getImage("news/authorHelm.png");
    }

    @Override
    public boolean shouldDownloadImage(IUserType imageKey) {
        return true;
    }

    @Override
    public File getImageLocation(IUserType imageKey) {
        return new File(this.directories.getAssetsDirectory(), "avatars" + File.separator + imageKey.getDisplayName() + ".png");
    }

    @Override
    public BufferedImage getDefaultImage() {
        return this.defaultImage;
    }
}

