/*
 * Decompiled with CFR 0.152.
 */
package net.technicpack.launcher.io;

import com.google.gson.JsonSyntaxException;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import net.technicpack.launchercore.auth.IUserStore;
import net.technicpack.launchercore.auth.IUserType;
import net.technicpack.minecraftcore.MojangUtils;
import net.technicpack.utilslib.Utils;
import org.apache.commons.io.FileUtils;

public class TechnicUserStore
implements IUserStore,
Serializable {
    private Map<String, IUserType> savedUsers = new HashMap<String, IUserType>();
    private String lastUser;
    private transient File usersFile;

    private TechnicUserStore() {
    }

    protected TechnicUserStore(File userFile) {
        this.usersFile = userFile;
    }

    public static TechnicUserStore load(File userFile) {
        if (!userFile.exists()) {
            Utils.getLogger().log(Level.WARNING, String.format("Unable to load users from %s because it does not exist.", userFile));
            return new TechnicUserStore(userFile);
        }
        try {
            String json = FileUtils.readFileToString(userFile, StandardCharsets.UTF_8);
            TechnicUserStore newModel = MojangUtils.getGson().fromJson(json, TechnicUserStore.class);
            if (newModel != null) {
                newModel.cleanupSavedUsers();
                newModel.setUserFile(userFile);
                return newModel;
            }
        }
        catch (JsonSyntaxException | IOException e) {
            Utils.getLogger().log(Level.WARNING, String.format("Unable to load users from %s", userFile));
        }
        return new TechnicUserStore(userFile);
    }

    public void setUserFile(File userFile) {
        this.usersFile = userFile;
    }

    public void save() {
        String json = MojangUtils.getGson().toJson(this);
        try {
            FileUtils.writeStringToFile(this.usersFile, json, StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            Utils.getLogger().log(Level.WARNING, String.format("Unable to save users %s", this.usersFile));
        }
    }

    @Override
    public void addUser(IUserType user) {
        this.savedUsers.put(user.getUsername(), user);
        this.save();
    }

    @Override
    public void removeUser(String username) {
        this.savedUsers.remove(username);
        this.save();
    }

    @Override
    public IUserType getUser(String accountName) {
        return this.savedUsers.get(accountName);
    }

    @Override
    public Collection<String> getUsers() {
        return this.savedUsers.keySet();
    }

    @Override
    public Collection<IUserType> getSavedUsers() {
        return this.savedUsers.values();
    }

    @Override
    public void setLastUser(String lastUser) {
        this.lastUser = lastUser;
        this.save();
    }

    @Override
    public String getLastUser() {
        return this.lastUser;
    }

    private void cleanupSavedUsers() {
        this.savedUsers.values().removeAll(Collections.singleton(null));
    }
}

