/*
 * Decompiled with CFR 0.152.
 */
package net.technicpack.launcher.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.EventQueue;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Collection;
import java.util.Locale;
import java.util.logging.Level;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingWorker;
import javax.swing.border.LineBorder;
import javax.swing.plaf.metal.MetalComboBoxUI;
import net.technicpack.launcher.settings.TechnicSettings;
import net.technicpack.launcher.ui.UIConstants;
import net.technicpack.launchercore.auth.IAuthListener;
import net.technicpack.launchercore.auth.IUserType;
import net.technicpack.launchercore.auth.UserModel;
import net.technicpack.launchercore.exception.AuthenticationException;
import net.technicpack.launchercore.exception.MicrosoftAuthException;
import net.technicpack.launchercore.exception.ResponseException;
import net.technicpack.launchercore.exception.SessionException;
import net.technicpack.launchercore.image.ImageRepository;
import net.technicpack.minecraftcore.microsoft.auth.MicrosoftUser;
import net.technicpack.minecraftcore.warez.WarezUser;
import net.technicpack.ui.UIUtils;
import net.technicpack.ui.controls.DraggableFrame;
import net.technicpack.ui.controls.RoundedButton;
import net.technicpack.ui.controls.borders.RoundBorder;
import net.technicpack.ui.controls.lang.LanguageCellRenderer;
import net.technicpack.ui.controls.lang.LanguageCellUI;
import net.technicpack.ui.controls.list.SimpleButtonComboUI;
import net.technicpack.ui.controls.list.popupformatters.RoundedBorderFormatter;
import net.technicpack.ui.controls.login.UserCellEditor;
import net.technicpack.ui.controls.login.UserCellRenderer;
import net.technicpack.ui.lang.IRelocalizableResource;
import net.technicpack.ui.lang.ResourceLoader;
import net.technicpack.ui.listitems.LanguageItem;
import net.technicpack.utilslib.DesktopUtils;
import net.technicpack.utilslib.JavaUtils;
import net.technicpack.utilslib.Utils;

public class LoginFrame
extends DraggableFrame
implements IRelocalizableResource,
IAuthListener {
    private transient ResourceLoader resources;
    private final transient ImageRepository<IUserType> skinRepository;
    private final transient UserModel userModel;
    private final transient TechnicSettings settings;
    private RoundedButton addMicrosoft;
    private RoundedButton cancelMsa;
    private RoundedButton login;
    private RoundedButton addWarez;
    private JLabel warezUsernameLabel;
    private JTextField warezUsername;
    private JLabel selectLabel;
    private JLabel visitBrowser;
    private JComboBox<IUserType> nameSelect;
    private JComboBox<LanguageItem> languages;
    private transient MsaLoginSwingWorker msaLoginSwingWorker;
    private static final int FRAME_WIDTH = 347;
    private static final int FRAME_HEIGHT = 399;

    public LoginFrame(ResourceLoader resources, TechnicSettings settings, UserModel userModel, ImageRepository<IUserType> skinRepository) {
        this.skinRepository = skinRepository;
        this.userModel = userModel;
        this.settings = settings;
        this.setSize(347, 399);
        this.setTitle("Technic Launcher - Login");
        this.setDefaultCloseOperation(3);
        this.getContentPane().setBackground(UIConstants.COLOR_CENTRAL_BACK_OPAQUE);
        this.relocalize(resources);
        this.setLocationRelativeTo(null);
    }

    @Override
    public void relocalize(ResourceLoader loader) {
        this.resources = loader;
        this.resources.registerResource(this);
        this.setIconImage(this.resources.getImage("icon.png"));
        this.getContentPane().removeAll();
        this.setLayout(null);
        this.nameSelect = null;
        this.initComponents();
        this.refreshSelectedUsers();
        EventQueue.invokeLater(() -> {
            this.invalidate();
            this.repaint();
        });
    }

    @Override
    public void userChanged(IUserType user) {
        if (user == null) {
            this.setVisible(true);
            this.refreshSelectedUsers();
            if (this.nameSelect.isVisible()) {
                this.nameSelect.grabFocus();
            }
            EventQueue.invokeLater(() -> {
                this.invalidate();
                this.repaint();
            });
        } else {
            this.setVisible(false);
        }
    }

    private void initComponents() {
        this.setLayout(new GridBagLayout());
        JButton closeButton = new JButton();
        closeButton.setContentAreaFilled(false);
        closeButton.setBorder(BorderFactory.createEmptyBorder());
        closeButton.setIcon(this.resources.getIcon("close.png"));
        closeButton.setCursor(Cursor.getPredefinedCursor(12));
        closeButton.addActionListener(e -> this.closeButtonClicked());
        closeButton.setFocusable(false);
        this.add((Component)closeButton, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 12, 0, new Insets(7, 0, 0, 7), 0, 0));
        JLabel platformImage = new JLabel();
        platformImage.setIcon(this.resources.getIcon("platform_logo.png"));
        this.add((Component)platformImage, new GridBagConstraints(0, 0, 3, 1, 0.0, 0.0, 10, 0, new Insets(30, 0, 0, 0), 0, 0));
        this.selectLabel = new JLabel(this.resources.getString("login.select", new String[0]));
        this.selectLabel.setFont(this.resources.getFont("OpenSans+Cyberbit.ttf", 16.0f));
        this.selectLabel.setForeground(UIConstants.COLOR_WHITE_TEXT);
        this.add((Component)this.selectLabel, new GridBagConstraints(0, 2, 3, 1, 0.0, 0.0, 17, 0, new Insets(10, 20, 0, 20), 0, 0));
        this.nameSelect = new JComboBox();
        if (System.getProperty("os.name").toLowerCase(Locale.ROOT).contains("mac")) {
            this.nameSelect.setUI(new MetalComboBoxUI());
        }
        this.nameSelect.setFont(this.resources.getFont("OpenSans+Cyberbit.ttf", 16.0f));
        this.nameSelect.setEditable(true);
        this.nameSelect.setBorder(new RoundBorder(UIConstants.COLOR_BUTTON_BLUE, 1, 10));
        this.nameSelect.setForeground(UIConstants.COLOR_BUTTON_BLUE);
        this.nameSelect.setBackground(UIConstants.COLOR_FORM_ELEMENT_INTERNAL);
        this.nameSelect.setVisible(false);
        UserCellRenderer userRenderer = new UserCellRenderer(this.resources, this.skinRepository);
        userRenderer.setFont(this.resources.getFont("OpenSans+Cyberbit.ttf", 16.0f));
        userRenderer.setSelectedBackgroundColor(UIConstants.COLOR_FORM_ELEMENT_INTERNAL);
        userRenderer.setSelectedForegroundColor(UIConstants.COLOR_BUTTON_BLUE);
        userRenderer.setUnselectedBackgroundColor(UIConstants.COLOR_CENTRAL_BACK_OPAQUE);
        userRenderer.setUnselectedForegroundColor(UIConstants.COLOR_BUTTON_BLUE);
        this.nameSelect.setRenderer(userRenderer);
        UserCellEditor userEditor = new UserCellEditor(this.resources.getFont("OpenSans+Cyberbit.ttf", 16.0f), this.skinRepository, UIConstants.COLOR_BUTTON_BLUE);
        this.nameSelect.setEditor(userEditor);
        this.nameSelect.setUI(new SimpleButtonComboUI(new RoundedBorderFormatter(new RoundBorder(UIConstants.COLOR_BUTTON_BLUE, 1, 0)), this.resources, UIConstants.COLOR_SCROLL_TRACK, UIConstants.COLOR_SCROLL_THUMB));
        this.nameSelect.addActionListener(e -> this.setCurrentUser((IUserType)this.nameSelect.getSelectedItem()));
        this.add(this.nameSelect, new GridBagConstraints(0, 3, 3, 1, 0.0, 0.0, 10, 1, new Insets(3, 20, 0, 20), 4, 4));
        this.login = new RoundedButton(this.resources.getString("login.button", new String[0]));
        this.login.setBorder(BorderFactory.createEmptyBorder(5, 17, 10, 17));
        this.login.setFont(this.resources.getFont("OpenSans+Cyberbit.ttf", 18.0f));
        this.login.setContentAreaFilled(false);
        this.login.setForeground(UIConstants.COLOR_BUTTON_BLUE);
        this.login.setHoverForeground(UIConstants.COLOR_BLUE);
        this.login.addActionListener(e -> this.login());
        this.add((Component)this.login, new GridBagConstraints(0, 6, 0, 1, 0.0, 0.0, 10, 2, new Insets(12, 20, 0, 20), 0, 0));
        this.addMicrosoft = new RoundedButton(this.resources.getString("login.addmicrosoft", new String[0]));
        this.addMicrosoft.setBorder(BorderFactory.createEmptyBorder(5, 17, 10, 17));
        this.addMicrosoft.setFont(this.resources.getFont("OpenSans+Cyberbit.ttf", 14.0f));
        this.addMicrosoft.setContentAreaFilled(false);
        this.addMicrosoft.setForeground(UIConstants.COLOR_BUTTON_BLUE);
        this.addMicrosoft.setHoverForeground(UIConstants.COLOR_BLUE);
        this.addMicrosoft.addActionListener(e -> this.addMicrosoftAccount());
        this.add((Component)this.addMicrosoft, new GridBagConstraints(0, 7, 0, 1, 0.0, 0.0, 10, 2, new Insets(50, 20, 0, 20), 0, 0));
        this.addWarez = new RoundedButton(this.resources.getString("login.addwarez", new String[0]));
        this.addWarez.setBorder(BorderFactory.createEmptyBorder(5, 17, 10, 17));
        this.addWarez.setFont(this.resources.getFont("OpenSans+Cyberbit.ttf", 14.0f));
        this.addWarez.setContentAreaFilled(false);
        this.addWarez.setForeground(UIConstants.COLOR_BUTTON_BLUE);
        this.addWarez.setHoverForeground(UIConstants.COLOR_BLUE);
        this.addWarez.addActionListener(e -> this.addWarezAccount());
        this.add((Component)this.addWarez, new GridBagConstraints(0, 9, 0, 1, 0.0, 0.0, 10, 2, new Insets(12, 20, 0, 20), 0, 0));
        this.warezUsernameLabel = new JLabel(this.resources.getString("login.username", new String[0]));
        this.warezUsernameLabel.setFont(this.resources.getFont("OpenSans+Cyberbit.ttf", 16.0f));
        this.warezUsernameLabel.setForeground(UIConstants.COLOR_WHITE_TEXT);
        this.warezUsernameLabel.setVisible(false);
        this.add((Component)this.warezUsernameLabel, new GridBagConstraints(0, 2, 3, 1, 0.0, 0.0, 17, 0, new Insets(10, 20, 0, 20), 0, 0));
        this.warezUsername = new JTextField();
        this.warezUsername.setBorder(new RoundBorder(UIConstants.COLOR_BUTTON_BLUE, 1, 10));
        this.warezUsername.setFont(this.resources.getFont("OpenSans+Cyberbit.ttf", 16.0f));
        this.warezUsername.setBackground(UIConstants.COLOR_FORM_ELEMENT_INTERNAL);
        this.warezUsername.setForeground(UIConstants.COLOR_BUTTON_BLUE);
        this.warezUsername.setCaretColor(UIConstants.COLOR_BUTTON_BLUE);
        this.warezUsername.setVisible(false);
        this.add((Component)this.warezUsername, new GridBagConstraints(0, 3, 3, 1, 0.0, 0.0, 10, 1, new Insets(3, 20, 0, 20), 4, 17));
        this.cancelMsa = new RoundedButton(this.resources.getString("login.cancel", new String[0]));
        this.cancelMsa.setBorder(BorderFactory.createEmptyBorder(5, 17, 10, 17));
        this.cancelMsa.setFont(this.resources.getFont("OpenSans+Cyberbit.ttf", 16.0f));
        this.cancelMsa.setContentAreaFilled(false);
        this.cancelMsa.setForeground(UIConstants.COLOR_BUTTON_BLUE);
        this.cancelMsa.setHoverForeground(UIConstants.COLOR_BLUE);
        this.cancelMsa.setVisible(false);
        this.cancelMsa.addActionListener(e -> this.cancelMsaLogin());
        this.add((Component)this.cancelMsa, new GridBagConstraints(0, 8, 0, 1, 0.0, 0.0, 10, 2, new Insets(50, 20, 0, 20), 0, 0));
        this.add(Box.createVerticalGlue(), new GridBagConstraints(0, 8, 3, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        JPanel linkPane = new JPanel();
        linkPane.setBackground(UIConstants.COLOR_SELECTOR_BACK);
        linkPane.setBorder(BorderFactory.createEmptyBorder(7, 0, 7, 0));
        linkPane.setLayout(new BoxLayout(linkPane, 2));
        linkPane.add(Box.createHorizontalStrut(8));
        this.languages = new JComboBox();
        String defaultLocaleText = this.resources.getString("launcheroptions.language.default", new String[0]);
        if (!this.resources.isDefaultLocaleSupported()) {
            defaultLocaleText = defaultLocaleText.concat(" (" + this.resources.getString("launcheroptions.language.unavailable", new String[0]) + ")");
        }
        UIUtils.populateLanguageSelector(defaultLocaleText, this.languages, this.resources, this.settings);
        this.languages.setBorder(BorderFactory.createEmptyBorder());
        this.languages.setFont(this.resources.getFont("OpenSans+Cyberbit.ttf", 14.0f));
        this.languages.setUI(new LanguageCellUI(new RoundedBorderFormatter(new LineBorder(Color.black, 1)), UIConstants.COLOR_SCROLL_TRACK, UIConstants.COLOR_SCROLL_THUMB));
        this.languages.setForeground(UIConstants.COLOR_WHITE_TEXT);
        this.languages.setBackground(UIConstants.COLOR_SELECTOR_BACK);
        this.languages.setRenderer(new LanguageCellRenderer(this.resources, "globe.png", UIConstants.COLOR_SELECTOR_BACK, UIConstants.COLOR_WHITE_TEXT));
        this.languages.setEditable(false);
        this.languages.setFocusable(false);
        this.languages.addActionListener(e -> this.languageChanged());
        linkPane.add(this.languages);
        linkPane.add(Box.createHorizontalGlue());
        JButton termsLink = new JButton(this.resources.getString("login.terms", new String[0]));
        termsLink.setContentAreaFilled(false);
        termsLink.setBorder(BorderFactory.createEmptyBorder());
        termsLink.setForeground(UIConstants.COLOR_WHITE_TEXT);
        termsLink.setFont(this.resources.getFont("OpenSans+Cyberbit.ttf", 14.0f));
        termsLink.setCursor(Cursor.getPredefinedCursor(12));
        termsLink.addActionListener(e -> this.visitTerms());
        linkPane.add(termsLink);
        linkPane.add(Box.createHorizontalStrut(8));
        this.add((Component)linkPane, new GridBagConstraints(0, 10, 3, 1, 1.0, 0.0, 15, 2, new Insets(0, 0, 0, 0), 0, 0));
    }

    protected void closeButtonClicked() {
        System.exit(0);
    }

    protected void visitTerms() {
        DesktopUtils.browseUrl("https://www.technicpack.net/terms");
    }

    protected void refreshSelectedUsers() {
        Collection<IUserType> users = this.userModel.getUsers();
        IUserType lastUser = this.userModel.getLastUser();
        if (users.isEmpty()) {
            this.setAccountSelectVisibility(false);
            this.setAddAccountVisibility(true);
            this.clearCurrentUser();
        } else {
            this.nameSelect.setVisible(true);
            this.nameSelect.removeAllItems();
            for (IUserType account : users) {
                this.nameSelect.addItem(account);
            }
            if (lastUser == null) {
                lastUser = users.iterator().next();
            }
            this.setCurrentUser(lastUser);
        }
    }

    protected void login() {
        if (this.warezUsername.isVisible()) {
            if (this.warezUsername.getText().length() < 3) {
                JOptionPane.showMessageDialog(this, "Nickname must be at least 3 characters long.", "Invalid nickname", 0);
                return;
            }
            this.newWarezLogin(this.warezUsername.getText());
            return;
        }
        IUserType user = (IUserType)this.nameSelect.getSelectedItem();
        if (user == null) {
            Utils.getLogger().log(Level.WARNING, "Attempted to login with a null user.");
            return;
        }
        this.login(user);
    }

    protected void addMicrosoftAccount() {
        String javaVersion = System.getProperty("java.version");
        if (JavaUtils.compareVersions(javaVersion, "1.8.0_91") < 0) {
            Utils.getLogger().log(Level.SEVERE, String.format("Aborting MSA login, Java version is too old (%s)", javaVersion));
            JOptionPane.showMessageDialog(this, this.resources.getString("msa.update.steps", new String[0]), this.resources.getString("msa.update.title", new String[0]), 0);
            DesktopUtils.browseUrl("https://api.adoptium.net/v3/installer/latest/21/ga/windows/x64/jre/hotspot/normal/eclipse?project=jdk");
            return;
        }
        this.newMicrosoftLogin();
    }

    protected void cancelMsaLogin() {
        if (this.msaLoginSwingWorker != null && !this.msaLoginSwingWorker.isDone()) {
            this.userModel.getMicrosoftAuthenticator().stopReceiver();
        }
    }

    protected void addWarezAccount() {
        this.setWarezLoginVisibility(true);
        this.setAddAccountVisibility(false);
        this.setAccountSelectVisibility(false);
        this.login.setVisible(true);
    }

    protected void clearCurrentUser() {
        this.nameSelect.setSelectedItem(null);
        this.warezUsername.setText("");
    }

    protected void setCurrentUser(IUserType user) {
        if (user == null) {
            this.clearCurrentUser();
            return;
        }
        this.setAccountSelectVisibility(true);
        this.setAddAccountVisibility(true);
        this.setWarezLoginVisibility(false);
        this.nameSelect.setSelectedItem(user);
    }

    protected void forgetUser(IUserType user) {
        this.userModel.removeUser(user);
        this.refreshSelectedUsers();
    }

    protected void languageChanged() {
        String langCode = ((LanguageItem)this.languages.getSelectedItem()).getLangCode();
        this.settings.setLanguageCode(langCode);
        this.resources.setLocale(langCode);
    }

    private void setWarezLoginVisibility(boolean visible) {
        this.warezUsernameLabel.setVisible(visible);
        this.warezUsername.setVisible(visible);
    }

    private void setAccountSelectVisibility(boolean visible) {
        this.selectLabel.setVisible(visible);
        this.nameSelect.setVisible(visible);
        this.login.setVisible(visible);
    }

    private void setAddAccountVisibility(boolean visible) {
        this.addMicrosoft.setVisible(visible);
        this.addWarez.setVisible(visible);
    }

    private void login(IUserType user) {
        block4: {
            try {
                user.login(this.userModel);
                this.userModel.addUser(user);
                this.userModel.setCurrentUser(user);
                this.setCurrentUser(user);
            }
            catch (SessionException e) {
                JOptionPane.showMessageDialog(this, "Please log in again for user " + user.getDisplayName(), e.getMessage(), 0);
                this.forgetUser(user);
            }
            catch (ResponseException e) {
                JOptionPane.showMessageDialog(this, e.getMessage(), e.getError(), 0);
                this.forgetUser(user);
            }
            catch (AuthenticationException e) {
                Utils.getLogger().log(Level.SEVERE, e.getMessage(), e);
                if (0 != JOptionPane.showConfirmDialog(this, "The auth servers are inaccessible. Would you like to play in offline mode?", "Offline mode", 0, 2)) break block4;
                this.userModel.setLastUser(user);
                this.userModel.setCurrentUser(new MicrosoftUser(user.getId(), user.getUsername()));
            }
        }
    }

    private void newMicrosoftLogin() {
        this.setAccountSelectVisibility(false);
        this.setAddAccountVisibility(false);
        this.cancelMsa.setVisible(true);
        if (this.msaLoginSwingWorker == null || this.msaLoginSwingWorker.isDone()) {
            this.msaLoginSwingWorker = new MsaLoginSwingWorker(this);
            this.msaLoginSwingWorker.execute();
        }
    }

    private void newWarezLogin(String username) {
        WarezUser newUser = new WarezUser(username);
        this.userModel.addUser(newUser);
        this.userModel.setCurrentUser(newUser);
        this.setCurrentUser(newUser);
    }

    private class MsaLoginSwingWorker
    extends SwingWorker<Void, Void> {
        private final JFrame parent;

        public MsaLoginSwingWorker(JFrame parent) {
            this.parent = parent;
        }

        @Override
        protected Void doInBackground() {
            try {
                MicrosoftUser microsoftUser = LoginFrame.this.userModel.getMicrosoftAuthenticator().loginNewUser();
                LoginFrame.this.userModel.addUser(microsoftUser);
                LoginFrame.this.userModel.setCurrentUser(microsoftUser);
                LoginFrame.this.setCurrentUser(microsoftUser);
            }
            catch (MicrosoftAuthException e) {
                Utils.getLogger().log(Level.SEVERE, e.getMessage(), e);
                switch (e.getType()) {
                    case UNDERAGE: {
                        JOptionPane.showMessageDialog(this.parent, "Your Xbox account is underage and will need to be added to a Family to play this game.", "Underage Error", 0);
                        break;
                    }
                    case NO_XBOX_ACCOUNT: {
                        JOptionPane.showMessageDialog(this.parent, "You don't have an Xbox account associated with this Microsoft account.\nPlease login at minecraft.net and set up an Xbox account, then try to login here again.", "No Xbox Account", 0);
                        DesktopUtils.browseUrl("https://www.minecraft.net/login");
                        break;
                    }
                    case NO_PROFILE: {
                        JOptionPane.showMessageDialog(this.parent, "You don't have a Minecraft profile set up yet.\nPlease open the Minecraft Launcher or go to minecraft.net and set up a Minecraft profile before attempting to use Technic Launcher.", "No Minecraft Profile", 0);
                        DesktopUtils.browseUrl("https://www.minecraft.net/msaprofile/mygames/editprofile");
                        break;
                    }
                    case NO_MINECRAFT: {
                        JOptionPane.showMessageDialog(this.parent, "This account has not purchased Minecraft Java Edition.", "No Minecraft", 0);
                        break;
                    }
                    case DNS: {
                        JOptionPane.showMessageDialog(this.parent, "DNS failure: " + e.getMessage(), "DNS failure during authentication", 0);
                        break;
                    }
                    default: {
                        JOptionPane.showMessageDialog(this.parent, e.getMessage(), "Add Microsoft Account Failed", 0);
                    }
                }
            }
            return null;
        }

        @Override
        protected void done() {
            LoginFrame.this.cancelMsa.setVisible(false);
            LoginFrame.this.setAccountSelectVisibility(!LoginFrame.this.userModel.getUsers().isEmpty());
            LoginFrame.this.setAddAccountVisibility(true);
        }
    }
}

