/*
 * Decompiled with CFR 0.152.
 */
package net.technicpack.launcher.ui.components;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Locale;
import javax.accessibility.Accessible;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.JToolTip;
import javax.swing.border.LineBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.HyperlinkEvent;
import javax.swing.filechooser.FileFilter;
import javax.swing.plaf.basic.BasicComboPopup;
import javax.swing.plaf.metal.MetalComboBoxUI;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import net.technicpack.autoupdate.IBuildNumber;
import net.technicpack.launcher.LauncherMain;
import net.technicpack.launcher.settings.StartupParameters;
import net.technicpack.launcher.settings.TechnicSettings;
import net.technicpack.launcher.ui.InstallerFrame;
import net.technicpack.launcher.ui.UIConstants;
import net.technicpack.launcher.ui.listitems.OnLaunchItem;
import net.technicpack.launcher.ui.listitems.StreamItem;
import net.technicpack.launchercore.launch.java.IJavaRuntime;
import net.technicpack.launchercore.launch.java.JavaVersionRepository;
import net.technicpack.launchercore.launch.java.source.FileJavaSource;
import net.technicpack.launchercore.launch.java.version.FileBasedJavaRuntime;
import net.technicpack.launchercore.util.LaunchAction;
import net.technicpack.minecraftcore.launch.WindowType;
import net.technicpack.ui.UIUtils;
import net.technicpack.ui.controls.LauncherDialog;
import net.technicpack.ui.controls.RoundedButton;
import net.technicpack.ui.controls.TooltipWarning;
import net.technicpack.ui.controls.borders.RoundBorder;
import net.technicpack.ui.controls.lang.LanguageCellRenderer;
import net.technicpack.ui.controls.list.SimpleButtonComboUI;
import net.technicpack.ui.controls.list.popupformatters.RoundedBorderFormatter;
import net.technicpack.ui.controls.tabs.SimpleTabPane;
import net.technicpack.ui.lang.IRelocalizableResource;
import net.technicpack.ui.lang.ResourceLoader;
import net.technicpack.ui.listitems.LanguageItem;
import net.technicpack.ui.listitems.javaversion.Best64BitVersionItem;
import net.technicpack.ui.listitems.javaversion.DefaultVersionItem;
import net.technicpack.ui.listitems.javaversion.JavaVersionItem;
import net.technicpack.utilslib.DesktopUtils;
import net.technicpack.utilslib.Memory;
import net.technicpack.utilslib.OperatingSystem;

public class OptionsDialog
extends LauncherDialog
implements IRelocalizableResource {
    private static final int DIALOG_WIDTH = 830;
    private static final int DIALOG_HEIGHT = 564;
    private final TechnicSettings settings;
    private boolean hasShownStreamInfo = false;
    private ResourceLoader resources;
    private final JavaVersionRepository javaVersions;
    private final FileJavaSource fileJavaSource;
    private final IBuildNumber buildNumber;
    private final DocumentListener javaArgsListener = new DocumentListener(){

        @Override
        public void insertUpdate(DocumentEvent e) {
            OptionsDialog.this.changeJavaArgs();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            OptionsDialog.this.changeJavaArgs();
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            OptionsDialog.this.changeJavaArgs();
        }
    };
    private final DocumentListener dimensionListener = new DocumentListener(){

        @Override
        public void insertUpdate(DocumentEvent e) {
            OptionsDialog.this.changeWindowDimensions();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            OptionsDialog.this.changeWindowDimensions();
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            OptionsDialog.this.changeWindowDimensions();
        }
    };
    private final DocumentListener wrapperCommandListener = new DocumentListener(){

        @Override
        public void insertUpdate(DocumentEvent e) {
            OptionsDialog.this.changeWrapperCommand();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            OptionsDialog.this.changeWrapperCommand();
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            OptionsDialog.this.changeWrapperCommand();
        }
    };
    JComboBox<JavaVersionItem> versionSelect;
    JComboBox<Memory> memSelect;
    JTextArea javaArgs;
    JComboBox<StreamItem> streamSelect;
    JComboBox<OnLaunchItem> launchSelect;
    JComboBox<LanguageItem> langSelect;
    JTextField installField;
    JTextField clientId;
    JCheckBox showConsole;
    JCheckBox launchToModpacks;
    StartupParameters params;
    Component ramWarning;
    JCheckBox askFirstBox;
    JComboBox<String> useStencil;
    JComboBox<String> windowSelect;
    JTextField widthInput;
    JTextField heightInput;
    JTextField wrapperCommand;
    JCheckBox useMojangJava;

    public OptionsDialog(Frame owner, TechnicSettings settings, ResourceLoader resourceLoader, StartupParameters params, JavaVersionRepository javaVersions, FileJavaSource fileJavaSource, IBuildNumber buildNumber) {
        super(owner);
        this.settings = settings;
        this.params = params;
        this.javaVersions = javaVersions;
        this.fileJavaSource = fileJavaSource;
        this.buildNumber = buildNumber;
        this.relocalize(resourceLoader);
    }

    protected void closeDialog() {
        this.resources.unregisterResource(this);
        this.dispose();
    }

    protected void changeJavaArgs() {
        this.settings.setJavaArgs(this.javaArgs.getText().trim());
        this.settings.save();
    }

    protected void changeWrapperCommand() {
        this.settings.setWrapperCommand(this.wrapperCommand.getText().trim());
        this.settings.save();
    }

    protected void copyCid() {
        StringSelection selection = new StringSelection(this.clientId.getText());
        Toolkit.getDefaultToolkit().getSystemClipboard().setContents(selection, null);
    }

    protected void changeShowConsole() {
        this.settings.setShowConsole(this.showConsole.isSelected());
        LauncherMain.setConsoleVisible(this.showConsole.isSelected());
        this.settings.save();
    }

    protected void changeAskFirst() {
        this.settings.setAutoAcceptModpackRequirements(!this.askFirstBox.isSelected());
        this.settings.save();
    }

    protected void changeUseMojangJava() {
        int result;
        if (!this.useMojangJava.isSelected() && (result = JOptionPane.showConfirmDialog(this, this.resources.getString("launcheroptions.java.mojangJreWarning.text", new String[0]), this.resources.getString("launcheroptions.java.mojangJreWarning.title", new String[0]), 1, 2)) != 0) {
            this.useMojangJava.setSelected(this.settings.shouldUseMojangJava());
            return;
        }
        this.settings.setUseMojangJava(this.useMojangJava.isSelected());
        this.settings.save();
    }

    protected void changeLaunchToModpacks() {
        this.settings.setLaunchToModpacks(this.launchToModpacks.isSelected());
        this.settings.save();
    }

    protected void changeJavaVersion() {
        JavaVersionItem javaVersionItem = (JavaVersionItem)this.versionSelect.getSelectedItem();
        String version = javaVersionItem.getVersionNumber();
        boolean is64 = javaVersionItem.is64Bit();
        this.javaVersions.setSelectedVersion(javaVersionItem.getJavaVersion());
        this.settings.setJavaVersion(version);
        this.settings.setPrefer64Bit(is64);
        this.settings.save();
        this.rebuildMemoryList();
    }

    protected void selectOtherVersion() {
        JFileChooser chooser = new JFileChooser();
        chooser.setFileSelectionMode(0);
        final String osJavaName = new File(OperatingSystem.getJavaDir()).getName();
        chooser.setFileFilter(new FileFilter(){

            @Override
            public boolean accept(File f) {
                if (f.isDirectory()) {
                    return true;
                }
                return f.getName().equals(osJavaName);
            }

            @Override
            public String getDescription() {
                return OptionsDialog.this.resources.getString("launcheroptions.java.filter", osJavaName);
            }
        });
        int result = chooser.showOpenDialog(this);
        if (result == 0) {
            if (chooser.getSelectedFile() == null || !chooser.getSelectedFile().exists() || !chooser.getSelectedFile().canExecute()) {
                JOptionPane.showMessageDialog(this, this.resources.getString("launcheroptions.java.badfile", new String[0]));
                return;
            }
            FileBasedJavaRuntime chosenJava = new FileBasedJavaRuntime(chooser.getSelectedFile());
            if (!chosenJava.isValid()) {
                JOptionPane.showMessageDialog(this, this.resources.getString("launcheroptions.java.badfile", new String[0]));
                return;
            }
            if (!this.javaVersions.addVersion(chosenJava)) {
                JOptionPane.showMessageDialog(this, this.resources.getString("launcheroptions.java.versionexists", new String[0]));
                return;
            }
            this.fileJavaSource.addVersion(chosenJava);
            this.javaVersions.setSelectedVersion(chosenJava);
            JavaVersionItem item = new JavaVersionItem(chosenJava, this.resources);
            this.versionSelect.addItem(item);
            this.versionSelect.setSelectedItem(item);
            this.settings.setJavaVersion(chosenJava.getVersion());
            this.settings.setPrefer64Bit(chosenJava.is64Bit());
            this.settings.save();
        }
    }

    protected void changeMemory() {
        this.settings.setMemory(((Memory)this.memSelect.getSelectedItem()).getSettingsId());
        this.settings.save();
    }

    protected void changeStream() {
        this.settings.setBuildStream(((StreamItem)this.streamSelect.getSelectedItem()).getStream());
        this.settings.save();
        if (!this.hasShownStreamInfo) {
            JOptionPane.showMessageDialog(this, this.resources.getString("launcheroptions.streamchange.text", new String[0]), this.resources.getString("launcheroptions.streamchange.title", new String[0]), 1);
            this.hasShownStreamInfo = true;
        }
    }

    protected void changeLaunchAction() {
        this.settings.setLaunchAction(((OnLaunchItem)this.launchSelect.getSelectedItem()).getLaunchAction());
        this.settings.save();
    }

    protected void changeLanguage() {
        this.settings.setLanguageCode(((LanguageItem)this.langSelect.getSelectedItem()).getLangCode());
        this.resources.setLocale(((LanguageItem)this.langSelect.getSelectedItem()).getLangCode());
    }

    protected void changeWindowType() {
        switch (this.windowSelect.getSelectedIndex()) {
            case 0: {
                this.settings.setLaunchWindowType(WindowType.DEFAULT);
                break;
            }
            case 1: {
                this.settings.setLaunchWindowType(WindowType.FULLSCREEN);
                break;
            }
            case 2: {
                this.settings.setLaunchWindowType(WindowType.CUSTOM);
                this.changeWindowDimensions();
            }
        }
        this.updateDimensionsEnabled();
    }

    protected void changeEnableStencil() {
        this.settings.setUseStencilBuffer(this.useStencil.getSelectedIndex() == 0);
    }

    protected void changeWindowDimensions() {
        String widthStr = this.widthInput.getText();
        String heightStr = this.heightInput.getText();
        int width = 800;
        int height = 600;
        try {
            width = Integer.parseInt(widthStr);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        try {
            height = Integer.parseInt(heightStr);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        this.settings.setLaunchWindowDimensions(width, height);
    }

    protected void reinstall() {
        InstallerFrame frame = new InstallerFrame(this.resources, this.params, this.settings, this.getOwner());
        frame.setVisible(true);
        EventQueue.invokeLater(frame::requestFocus);
        this.dispose();
    }

    protected void openLogs() {
        DesktopUtils.open(new File(this.settings.getTechnicRoot().getAbsolutePath(), "logs"));
    }

    private void initControlValues() {
        this.javaArgs.getDocument().removeDocumentListener(this.javaArgsListener);
        this.javaArgs.setText(this.settings.getJavaArgs());
        this.javaArgs.getDocument().addDocumentListener(this.javaArgsListener);
        this.wrapperCommand.getDocument().removeDocumentListener(this.wrapperCommandListener);
        this.wrapperCommand.setText(this.settings.getWrapperCommand());
        this.wrapperCommand.getDocument().addDocumentListener(this.wrapperCommandListener);
        this.installField.setText(this.settings.getTechnicRoot().getAbsolutePath());
        this.clientId.setText(this.settings.getClientId());
        for (ActionListener listener : this.showConsole.getActionListeners()) {
            this.showConsole.removeActionListener(listener);
        }
        this.showConsole.setSelected(this.settings.getShowConsole());
        this.showConsole.addActionListener(e -> this.changeShowConsole());
        for (ActionListener listener : this.askFirstBox.getActionListeners()) {
            this.askFirstBox.removeActionListener(listener);
        }
        this.askFirstBox.setSelected(!this.settings.shouldAutoAcceptModpackRequirements());
        this.askFirstBox.addActionListener(e -> this.changeAskFirst());
        for (ActionListener listener : this.useMojangJava.getActionListeners()) {
            this.useMojangJava.removeActionListener(listener);
        }
        this.useMojangJava.setSelected(this.settings.shouldUseMojangJava());
        this.useMojangJava.addActionListener(e -> this.changeUseMojangJava());
        for (ActionListener listener : this.launchToModpacks.getActionListeners()) {
            this.launchToModpacks.removeActionListener(listener);
        }
        this.launchToModpacks.setSelected(this.settings.getLaunchToModpacks());
        this.launchToModpacks.addActionListener(e -> this.changeLaunchToModpacks());
        for (ActionListener listener : this.versionSelect.getActionListeners()) {
            this.versionSelect.removeActionListener(listener);
        }
        this.versionSelect.removeAllItems();
        this.versionSelect.addItem(new DefaultVersionItem(this.javaVersions.getDefaultVersion(), this.resources));
        IJavaRuntime best64Bit = this.javaVersions.getBest64BitVersion();
        if (best64Bit != null) {
            this.versionSelect.addItem(new Best64BitVersionItem(best64Bit, this.resources));
        }
        for (IJavaRuntime version : this.javaVersions.getVersions()) {
            this.versionSelect.addItem(new JavaVersionItem(version, this.resources));
        }
        String settingsVersion = this.settings.getJavaVersion();
        boolean settingsBitness = this.settings.getPrefer64Bit();
        if (settingsVersion == null || settingsVersion.isEmpty() || settingsVersion.equals("default")) {
            this.versionSelect.setSelectedIndex(0);
        } else if (settingsVersion.equals("64bit")) {
            this.versionSelect.setSelectedIndex(1);
        } else {
            for (int i = 2; i < this.versionSelect.getItemCount(); ++i) {
                if (!this.versionSelect.getItemAt(i).getVersionNumber().equals(settingsVersion) || this.versionSelect.getItemAt(i).is64Bit() != settingsBitness) continue;
                this.versionSelect.setSelectedIndex(i);
                break;
            }
        }
        this.versionSelect.addActionListener(e -> this.changeJavaVersion());
        this.rebuildMemoryList();
        for (ActionListener listener : this.streamSelect.getActionListeners()) {
            this.streamSelect.removeActionListener(listener);
        }
        this.streamSelect.removeAllItems();
        this.streamSelect.addItem(new StreamItem(this.resources.getString("launcheroptions.build.stable", new String[0]), "stable"));
        this.streamSelect.addItem(new StreamItem(this.resources.getString("launcheroptions.build.beta", new String[0]), "beta"));
        this.streamSelect.setSelectedIndex(this.settings.getBuildStream().equals("beta") ? 1 : 0);
        this.streamSelect.addActionListener(e -> this.changeStream());
        for (ActionListener listener : this.launchSelect.getActionListeners()) {
            this.launchSelect.removeActionListener(listener);
        }
        this.launchSelect.removeAllItems();
        this.launchSelect.addItem(new OnLaunchItem(this.resources.getString("launcheroptions.packlaunch.hide", new String[0]), LaunchAction.HIDE));
        this.launchSelect.addItem(new OnLaunchItem(this.resources.getString("launcheroptions.packlaunch.close", new String[0]), LaunchAction.CLOSE));
        this.launchSelect.addItem(new OnLaunchItem(this.resources.getString("launcheroptions.packlaunch.nothing", new String[0]), LaunchAction.NOTHING));
        switch (this.settings.getLaunchAction()) {
            case HIDE: {
                this.launchSelect.setSelectedIndex(0);
                break;
            }
            case CLOSE: {
                this.launchSelect.setSelectedIndex(1);
                break;
            }
            case NOTHING: {
                this.launchSelect.setSelectedIndex(2);
            }
        }
        this.launchSelect.addActionListener(e -> this.changeLaunchAction());
        for (ActionListener listener : this.langSelect.getActionListeners()) {
            this.langSelect.removeActionListener(listener);
        }
        this.langSelect.removeAllItems();
        String defaultLocaleText = this.resources.getString("launcheroptions.language.default", new String[0]);
        if (!this.resources.isDefaultLocaleSupported()) {
            defaultLocaleText = defaultLocaleText.concat(" (" + this.resources.getString("launcheroptions.language.unavailable", new String[0]) + ")");
        }
        this.langSelect.setRenderer(new LanguageCellRenderer(this.resources, null, this.langSelect.getBackground(), this.langSelect.getForeground()));
        UIUtils.populateLanguageSelector(defaultLocaleText, this.langSelect, this.resources, this.settings);
        this.langSelect.addActionListener(e -> this.changeLanguage());
        this.widthInput.getDocument().removeDocumentListener(this.dimensionListener);
        this.heightInput.getDocument().removeDocumentListener(this.dimensionListener);
        int width = this.settings.getCustomWidth();
        int height = this.settings.getCustomHeight();
        width = width < 1 ? 800 : width;
        height = height < 1 ? 600 : height;
        this.widthInput.setText(Integer.toString(width));
        this.heightInput.setText(Integer.toString(height));
        this.widthInput.getDocument().addDocumentListener(this.dimensionListener);
        this.heightInput.getDocument().addDocumentListener(this.dimensionListener);
        for (ActionListener listener : this.windowSelect.getActionListeners()) {
            this.windowSelect.removeActionListener(listener);
        }
        this.windowSelect.removeAllItems();
        this.windowSelect.addItem(this.resources.getString("launcheroptions.video.windowSize.default", new String[0]));
        this.windowSelect.addItem(this.resources.getString("launcheroptions.video.windowSize.fullscreen", new String[0]));
        this.windowSelect.addItem(this.resources.getString("launcheroptions.video.windowSize.custom", new String[0]));
        switch (this.settings.getLaunchWindowType()) {
            case DEFAULT: {
                this.windowSelect.setSelectedIndex(0);
                break;
            }
            case FULLSCREEN: {
                this.windowSelect.setSelectedIndex(1);
                break;
            }
            case CUSTOM: {
                this.windowSelect.setSelectedIndex(2);
            }
        }
        this.windowSelect.addActionListener(e -> this.changeWindowType());
        this.updateDimensionsEnabled();
        for (ActionListener listener : this.useStencil.getActionListeners()) {
            this.useStencil.removeActionListener(listener);
        }
        this.useStencil.removeAllItems();
        this.useStencil.addItem(this.resources.getString("launcheroptions.video.stencil.enabled", new String[0]));
        this.useStencil.addItem(this.resources.getString("launcheroptions.video.stencil.disabled", new String[0]));
        if (this.settings.shouldUseStencilBuffer()) {
            this.useStencil.setSelectedIndex(0);
        } else {
            this.useStencil.setSelectedIndex(1);
        }
        this.useStencil.addActionListener(e -> this.changeEnableStencil());
    }

    private void rebuildMemoryList() {
        for (ActionListener listener : this.memSelect.getActionListeners()) {
            this.memSelect.removeActionListener(listener);
        }
        Container parent = null;
        if (this.memSelect.getParent() != null) {
            parent = this.memSelect.getParent();
            parent.remove(this.memSelect);
            if (this.ramWarning != null) {
                parent.remove(this.ramWarning);
                this.ramWarning = null;
            }
        }
        this.memSelect.removeAllItems();
        boolean is64Bit = this.javaVersions.getSelectedVersion().is64Bit();
        long maxMemory = Memory.getAvailableMemory(is64Bit);
        for (int i = 0; i < Memory.memoryOptions.length; ++i) {
            if (Memory.memoryOptions[i].getMemoryMB() > maxMemory) continue;
            this.memSelect.addItem(Memory.memoryOptions[i]);
        }
        Memory currentMem = Memory.getMemoryFromId(this.settings.getMemory());
        Memory availableMem = Memory.getClosestAvailableMemory(currentMem, is64Bit);
        if (currentMem.getMemoryMB() != availableMem.getMemoryMB()) {
            this.settings.setMemory(availableMem.getSettingsId());
            this.settings.save();
        }
        this.memSelect.setSelectedItem(availableMem);
        this.memSelect.addActionListener(e -> this.changeMemory());
        if (parent != null) {
            boolean has64Bit;
            boolean bl = has64Bit = this.javaVersions.getBest64BitVersion() != null;
            if (is64Bit) {
                parent.add(this.memSelect, new GridBagConstraints(1, 1, 6, 1, 1.0, 0.0, 10, 1, new Insets(8, 16, 8, 80), 0, 16));
            } else {
                ImageIcon icon;
                String text;
                parent.add(this.memSelect, new GridBagConstraints(1, 1, 5, 1, 5.0, 0.0, 10, 1, new Insets(8, 16, 8, 0), 0, 16));
                JToolTip toolTip = new JToolTip();
                toolTip.setBackground(UIConstants.COLOR_FOOTER);
                toolTip.setForeground(UIConstants.COLOR_GREY_TEXT);
                toolTip.setBorder(BorderFactory.createCompoundBorder(new LineBorder(UIConstants.COLOR_GREY_TEXT), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
                toolTip.setFont(this.resources.getFont("OpenSans+Cyberbit.ttf", 14.0f));
                if (has64Bit) {
                    text = this.resources.getString("launcheroptions.java.use64bit", new String[0]);
                    icon = this.resources.getIcon("danger_icon.png");
                } else {
                    text = this.resources.getString("launcheroptions.java.get64bit", new String[0]);
                    icon = this.resources.getIcon("warning_icon.png");
                }
                this.ramWarning = new TooltipWarning((Icon)icon, toolTip);
                ((TooltipWarning)this.ramWarning).setToolTipText(text);
                parent.add(this.ramWarning, new GridBagConstraints(6, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(8, 8, 8, 80), 0, 0));
            }
            this.repaint();
        }
    }

    private void initComponents() {
        this.setSize(830, 564);
        this.setLayout(new BorderLayout());
        JPanel header = new JPanel();
        header.setBackground(Color.black);
        header.setLayout(new BoxLayout(header, 2));
        header.setBorder(BorderFactory.createEmptyBorder(4, 8, 4, 8));
        this.add((Component)header, "First");
        JLabel title = new JLabel(this.resources.getString("launcher.title.options", new String[0]));
        title.setFont(this.resources.getFont("Raleway+FireflySung.ttf", 26.0f));
        title.setForeground(UIConstants.COLOR_WHITE_TEXT);
        title.setOpaque(false);
        title.setIcon(this.resources.getIcon("options_cog.png"));
        title.setBorder(BorderFactory.createEmptyBorder(5, 0, 5, 0));
        header.add(title);
        header.add(Box.createHorizontalGlue());
        JButton closeButton = new JButton();
        closeButton.setIcon(this.resources.getIcon("close.png"));
        closeButton.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        closeButton.setContentAreaFilled(false);
        closeButton.setCursor(Cursor.getPredefinedCursor(12));
        closeButton.setFocusPainted(false);
        closeButton.addActionListener(e -> this.closeDialog());
        header.add(closeButton);
        SimpleTabPane centerPanel = new SimpleTabPane();
        centerPanel.setBackground(UIConstants.COLOR_FORM_ELEMENT_INTERNAL);
        centerPanel.setForeground(UIConstants.COLOR_GREY_TEXT);
        centerPanel.setSelectedBackground(UIConstants.COLOR_BLUE);
        centerPanel.setSelectedForeground(UIConstants.COLOR_WHITE_TEXT);
        centerPanel.setFont(this.resources.getFont("OpenSans+Cyberbit.ttf", 14.0f));
        centerPanel.setOpaque(true);
        this.add((Component)centerPanel, "Center");
        JPanel general = new JPanel();
        general.setBackground(UIConstants.COLOR_CENTRAL_BACK_OPAQUE);
        this.setupGeneralPanel(general);
        JPanel javaOptions = new JPanel();
        javaOptions.setBackground(UIConstants.COLOR_CENTRAL_BACK_OPAQUE);
        this.setupJavaOptionsPanel(javaOptions);
        JPanel videoOptions = new JPanel();
        videoOptions.setBackground(UIConstants.COLOR_CENTRAL_BACK_OPAQUE);
        this.setupVideoOptionsPanel(videoOptions);
        JPanel about = new JPanel();
        about.setBackground(UIConstants.COLOR_CENTRAL_BACK_OPAQUE);
        String linkText = "<a href=\"https://github.com/TechnicPack/\">" + this.resources.getString("launcheroptions.about.linktext", new String[0]) + "</a>";
        String aboutText = "<html><head><style type=\"text/css\">a{color:#309aeb}body{font-family: " + this.resources.getFont("OpenSans+Cyberbit.ttf", 12.0f).getFamily() + ";color:#D0D0D0}</style></head><body>";
        aboutText = aboutText + "<p>" + this.resources.getString("launcheroptions.about.copyright", this.buildNumber.getBuildNumber(), linkText) + "</p>";
        aboutText = aboutText + "<p>" + this.resources.getString("launcheroptions.about.romainguy", new String[0]) + "</p>";
        aboutText = aboutText + "<p>" + this.resources.getString("launcheroptions.about.summary", new String[0]) + "</p>";
        about.setLayout(new BorderLayout());
        JLabel buildCtrl = new JLabel(this.resources.getString("launcher.build.text", this.buildNumber.getBuildNumber(), this.resources.getString("launcher.build." + this.settings.getBuildStream(), new String[0])));
        buildCtrl.setForeground(UIConstants.COLOR_WHITE_TEXT);
        buildCtrl.setFont(this.resources.getFont("OpenSans+Cyberbit.ttf", 14.0f));
        buildCtrl.setBorder(BorderFactory.createEmptyBorder(6, 12, 6, 0));
        about.add((Component)buildCtrl, "South");
        JTextPane textPane = new JTextPane();
        textPane.setBorder(BorderFactory.createEmptyBorder(0, 24, 9, 24));
        textPane.setOpaque(false);
        textPane.setForeground(UIConstants.COLOR_WHITE_TEXT);
        textPane.setFont(this.resources.getFont("OpenSans+Cyberbit.ttf", 16.0f));
        textPane.setEditable(false);
        textPane.setHighlighter(null);
        textPane.setAlignmentX(0.0f);
        textPane.setContentType("text/html");
        textPane.addHyperlinkListener(e -> {
            if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                DesktopUtils.browseUrl(e.getURL().toString());
            }
        });
        SimpleAttributeSet attributes = new SimpleAttributeSet(textPane.getParagraphAttributes());
        StyleConstants.setLineSpacing(attributes, StyleConstants.getLineSpacing(attributes) * 1.3f);
        textPane.setParagraphAttributes(attributes, true);
        textPane.setText(aboutText);
        about.add((Component)textPane, "Center");
        centerPanel.addTab(this.resources.getString("launcheroptions.tab.general", new String[0]).toUpperCase(), general);
        centerPanel.addTab(this.resources.getString("launcheroptions.tab.java", new String[0]).toUpperCase(), javaOptions);
        centerPanel.addTab(this.resources.getString("launcheroptions.tab.video", new String[0]).toUpperCase(), videoOptions);
        centerPanel.addTab(this.resources.getString("launcheroptions.tab.about", new String[0]).toUpperCase(), about);
        centerPanel.setFocusable(false);
    }

    private void setupGeneralPanel(JPanel panel) {
        panel.setLayout(new GridBagLayout());
        JLabel streamLabel = new JLabel(this.resources.getString("launcheroptions.general.build", new String[0]));
        streamLabel.setFont(this.resources.getFont("OpenSans+Cyberbit.ttf", 16.0f));
        streamLabel.setForeground(UIConstants.COLOR_WHITE_TEXT);
        panel.add((Component)streamLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 40, 0, 0), 0, 0));
        this.streamSelect = new JComboBox();
        this.streamSelect.setFont(this.resources.getFont("OpenSans+Cyberbit.ttf", 16.0f));
        this.streamSelect.setEditable(false);
        this.streamSelect.setBorder(new RoundBorder(UIConstants.COLOR_BUTTON_BLUE, 1, 10));
        this.streamSelect.setForeground(UIConstants.COLOR_BUTTON_BLUE);
        this.streamSelect.setBackground(UIConstants.COLOR_FORM_ELEMENT_INTERNAL);
        this.streamSelect.setUI(new SimpleButtonComboUI(new RoundedBorderFormatter(new RoundBorder(UIConstants.COLOR_BUTTON_BLUE, 1, 0)), this.resources, UIConstants.COLOR_SCROLL_TRACK, UIConstants.COLOR_SCROLL_THUMB));
        this.streamSelect.setFocusable(false);
        Accessible child = this.streamSelect.getAccessibleContext().getAccessibleChild(0);
        BasicComboPopup popup = (BasicComboPopup)child;
        JList<Object> list = popup.getList();
        list.setSelectionForeground(UIConstants.COLOR_BUTTON_BLUE);
        list.setSelectionBackground(UIConstants.COLOR_FORM_ELEMENT_INTERNAL);
        list.setBackground(UIConstants.COLOR_CENTRAL_BACK_OPAQUE);
        panel.add(this.streamSelect, new GridBagConstraints(1, 0, 2, 1, 1.0, 0.0, 10, 1, new Insets(8, 16, 8, 16), 0, 16));
        JLabel langLabel = new JLabel(this.resources.getString("launcheroptions.general.lang", new String[0]));
        langLabel.setFont(this.resources.getFont("OpenSans+Cyberbit.ttf", 16.0f));
        langLabel.setForeground(UIConstants.COLOR_WHITE_TEXT);
        panel.add((Component)langLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 40, 0, 0), 0, 0));
        this.langSelect = new JComboBox();
        this.langSelect.setFont(this.resources.getFont("OpenSans+Cyberbit.ttf", 16.0f));
        this.langSelect.setEditable(false);
        this.langSelect.setBorder(new RoundBorder(UIConstants.COLOR_BUTTON_BLUE, 1, 10));
        this.langSelect.setForeground(UIConstants.COLOR_BUTTON_BLUE);
        this.langSelect.setBackground(UIConstants.COLOR_FORM_ELEMENT_INTERNAL);
        this.langSelect.setUI(new SimpleButtonComboUI(new RoundedBorderFormatter(new RoundBorder(UIConstants.COLOR_BUTTON_BLUE, 1, 0)), this.resources, UIConstants.COLOR_SCROLL_TRACK, UIConstants.COLOR_SCROLL_THUMB));
        this.langSelect.setFocusable(false);
        child = this.langSelect.getAccessibleContext().getAccessibleChild(0);
        popup = (BasicComboPopup)child;
        list = popup.getList();
        list.setSelectionForeground(UIConstants.COLOR_BUTTON_BLUE);
        list.setSelectionBackground(UIConstants.COLOR_FORM_ELEMENT_INTERNAL);
        list.setBackground(UIConstants.COLOR_CENTRAL_BACK_OPAQUE);
        panel.add(this.langSelect, new GridBagConstraints(1, 1, 2, 1, 1.0, 0.0, 10, 1, new Insets(8, 16, 8, 16), 0, 16));
        JLabel launchLabel = new JLabel(this.resources.getString("launcheroptions.general.onlaunch", new String[0]));
        launchLabel.setFont(this.resources.getFont("OpenSans+Cyberbit.ttf", 16.0f));
        launchLabel.setForeground(UIConstants.COLOR_WHITE_TEXT);
        panel.add((Component)launchLabel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 40, 0, 0), 0, 0));
        this.launchSelect = new JComboBox();
        this.launchSelect.setFont(this.resources.getFont("OpenSans+Cyberbit.ttf", 16.0f));
        this.launchSelect.setEditable(false);
        this.launchSelect.setBorder(new RoundBorder(UIConstants.COLOR_BUTTON_BLUE, 1, 10));
        this.launchSelect.setForeground(UIConstants.COLOR_BUTTON_BLUE);
        this.launchSelect.setBackground(UIConstants.COLOR_FORM_ELEMENT_INTERNAL);
        this.launchSelect.setUI(new SimpleButtonComboUI(new RoundedBorderFormatter(new RoundBorder(UIConstants.COLOR_BUTTON_BLUE, 1, 0)), this.resources, UIConstants.COLOR_SCROLL_TRACK, UIConstants.COLOR_SCROLL_THUMB));
        this.launchSelect.setFocusable(false);
        child = this.launchSelect.getAccessibleContext().getAccessibleChild(0);
        popup = (BasicComboPopup)child;
        list = popup.getList();
        list.setSelectionForeground(UIConstants.COLOR_BUTTON_BLUE);
        list.setSelectionBackground(UIConstants.COLOR_FORM_ELEMENT_INTERNAL);
        list.setBackground(UIConstants.COLOR_CENTRAL_BACK_OPAQUE);
        panel.add(this.launchSelect, new GridBagConstraints(1, 2, 2, 1, 1.0, 0.0, 10, 1, new Insets(8, 16, 8, 16), 0, 16));
        JLabel installLabel = new JLabel(this.resources.getString("launcheroptions.general.install", new String[0]));
        installLabel.setFont(this.resources.getFont("OpenSans+Cyberbit.ttf", 16.0f));
        installLabel.setForeground(UIConstants.COLOR_WHITE_TEXT);
        panel.add((Component)installLabel, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 40, 0, 0), 0, 0));
        this.installField = new JTextField("");
        this.installField.setFont(this.resources.getFont("OpenSans+Cyberbit.ttf", 16.0f));
        this.installField.setForeground(UIConstants.COLOR_BLUE);
        this.installField.setBackground(UIConstants.COLOR_FORM_ELEMENT_INTERNAL);
        this.installField.setHighlighter(null);
        this.installField.setEditable(false);
        this.installField.setCursor(null);
        this.installField.setBorder(new RoundBorder(UIConstants.COLOR_BUTTON_BLUE, 1, 8));
        panel.add((Component)this.installField, new GridBagConstraints(1, 3, 2, 1, 1.0, 0.0, 10, 1, new Insets(8, 16, 8, 16), 0, 16));
        RoundedButton reinstallButton = new RoundedButton(this.resources.getString("launcheroptions.install.change", new String[0]));
        reinstallButton.setFont(this.resources.getFont("OpenSans+Cyberbit.ttf", 16.0f));
        reinstallButton.setContentAreaFilled(false);
        reinstallButton.setForeground(UIConstants.COLOR_BUTTON_BLUE);
        reinstallButton.setHoverForeground(UIConstants.COLOR_BLUE);
        reinstallButton.addActionListener(e -> this.reinstall());
        panel.add((Component)reinstallButton, new GridBagConstraints(3, 3, 1, 1, 0.0, 0.0, 10, 1, new Insets(8, 0, 8, 0), 0, 0));
        JLabel clientIdField = new JLabel(this.resources.getString("launcheroptions.general.id", new String[0]));
        clientIdField.setFont(this.resources.getFont("OpenSans+Cyberbit.ttf", 16.0f));
        clientIdField.setForeground(UIConstants.COLOR_WHITE_TEXT);
        panel.add((Component)clientIdField, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 40, 0, 0), 0, 0));
        this.clientId = new JTextField("abc123");
        this.clientId.setFont(this.resources.getFont("OpenSans+Cyberbit.ttf", 16.0f));
        this.clientId.setForeground(UIConstants.COLOR_BLUE);
        this.clientId.setBackground(UIConstants.COLOR_FORM_ELEMENT_INTERNAL);
        this.clientId.setHighlighter(null);
        this.clientId.setEditable(false);
        this.clientId.setCursor(null);
        this.clientId.setBorder(new RoundBorder(UIConstants.COLOR_BUTTON_BLUE, 1, 8));
        panel.add((Component)this.clientId, new GridBagConstraints(1, 4, 2, 1, 1.0, 0.0, 10, 1, new Insets(8, 16, 8, 16), 0, 16));
        RoundedButton copyButton = new RoundedButton(this.resources.getString("launcheroptions.id.copy", new String[0]));
        copyButton.setFont(this.resources.getFont("OpenSans+Cyberbit.ttf", 16.0f));
        copyButton.setContentAreaFilled(false);
        copyButton.setForeground(UIConstants.COLOR_BUTTON_BLUE);
        copyButton.setHoverForeground(UIConstants.COLOR_BLUE);
        copyButton.addActionListener(e -> this.copyCid());
        panel.add((Component)copyButton, new GridBagConstraints(3, 4, 1, 1, 0.0, 0.0, 10, 1, new Insets(8, 0, 8, 0), 0, 0));
        panel.add(Box.createRigidArea(new Dimension(60, 0)), new GridBagConstraints(4, 3, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        JLabel showConsoleField = new JLabel(this.resources.getString("launcheroptions.general.console", new String[0]));
        showConsoleField.setFont(this.resources.getFont("OpenSans+Cyberbit.ttf", 16.0f));
        showConsoleField.setForeground(UIConstants.COLOR_WHITE_TEXT);
        panel.add((Component)showConsoleField, new GridBagConstraints(0, 5, 1, 1, 0.0, 0.0, 13, 0, new Insets(10, 40, 0, 0), 0, 0));
        this.showConsole = new JCheckBox("", false);
        this.showConsole.setOpaque(false);
        this.showConsole.setHorizontalAlignment(4);
        this.showConsole.setBorder(BorderFactory.createEmptyBorder());
        this.showConsole.setIconTextGap(0);
        this.showConsole.setSelectedIcon(this.resources.getIcon("checkbox_closed.png"));
        this.showConsole.setIcon(this.resources.getIcon("checkbox_open.png"));
        this.showConsole.setFocusPainted(false);
        panel.add((Component)this.showConsole, new GridBagConstraints(1, 5, 1, 1, 0.0, 0.0, 10, 0, new Insets(16, 16, 0, 0), 0, 0));
        JLabel launchToModpacksField = new JLabel(this.resources.getString("launcheroptions.general.modpacktab", new String[0]));
        launchToModpacksField.setFont(this.resources.getFont("OpenSans+Cyberbit.ttf", 16.0f));
        launchToModpacksField.setForeground(UIConstants.COLOR_WHITE_TEXT);
        panel.add((Component)launchToModpacksField, new GridBagConstraints(0, 6, 1, 1, 0.0, 0.0, 13, 0, new Insets(10, 40, 0, 0), 0, 0));
        this.launchToModpacks = new JCheckBox("", false);
        this.launchToModpacks.setOpaque(false);
        this.launchToModpacks.setHorizontalAlignment(4);
        this.launchToModpacks.setBorder(BorderFactory.createEmptyBorder());
        this.launchToModpacks.setIconTextGap(0);
        this.launchToModpacks.setSelectedIcon(this.resources.getIcon("checkbox_closed.png"));
        this.launchToModpacks.setIcon(this.resources.getIcon("checkbox_open.png"));
        this.launchToModpacks.setFocusPainted(false);
        panel.add((Component)this.launchToModpacks, new GridBagConstraints(1, 6, 1, 1, 0.0, 0.0, 10, 0, new Insets(16, 16, 0, 0), 0, 0));
        panel.add(Box.createGlue(), new GridBagConstraints(0, 7, 5, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        RoundedButton openLogs = new RoundedButton(this.resources.getString("launcheroptions.general.logs", new String[0]));
        openLogs.setFont(this.resources.getFont("OpenSans+Cyberbit.ttf", 16.0f));
        openLogs.setContentAreaFilled(false);
        openLogs.setForeground(UIConstants.COLOR_BUTTON_BLUE);
        openLogs.setHoverForeground(UIConstants.COLOR_BLUE);
        openLogs.setBorder(BorderFactory.createEmptyBorder(5, 17, 10, 17));
        openLogs.addActionListener(e -> this.openLogs());
        panel.add((Component)openLogs, new GridBagConstraints(0, 8, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 10, 10, 0), 0, 0));
    }

    private void updateDimensionsEnabled() {
        if (this.windowSelect.getSelectedIndex() == 2) {
            this.widthInput.setEnabled(true);
            this.heightInput.setEnabled(true);
            this.widthInput.setForeground(UIConstants.COLOR_BUTTON_BLUE);
            this.heightInput.setForeground(UIConstants.COLOR_BUTTON_BLUE);
            this.widthInput.setBorder(new RoundBorder(UIConstants.COLOR_BUTTON_BLUE, 1, 8));
            this.heightInput.setBorder(new RoundBorder(UIConstants.COLOR_BUTTON_BLUE, 1, 8));
        } else {
            this.widthInput.setEnabled(false);
            this.heightInput.setEnabled(false);
            this.widthInput.setForeground(UIConstants.COLOR_GREY_TEXT);
            this.heightInput.setForeground(UIConstants.COLOR_GREY_TEXT);
            this.widthInput.setBorder(new RoundBorder(UIConstants.COLOR_GREY_TEXT, 1, 8));
            this.heightInput.setBorder(new RoundBorder(UIConstants.COLOR_GREY_TEXT, 1, 8));
        }
    }

    private void setupVideoOptionsPanel(JPanel panel) {
        panel.setLayout(new GridBagLayout());
        JLabel streamLabel = new JLabel(this.resources.getString("launcheroptions.video.windowSize", new String[0]));
        streamLabel.setFont(this.resources.getFont("OpenSans+Cyberbit.ttf", 16.0f));
        streamLabel.setForeground(UIConstants.COLOR_WHITE_TEXT);
        panel.add((Component)streamLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 40, 0, 0), 0, 0));
        this.windowSelect = new JComboBox();
        if (System.getProperty("os.name").toLowerCase(Locale.ROOT).contains("mac")) {
            this.windowSelect.setUI(new MetalComboBoxUI());
        }
        this.windowSelect.setFont(this.resources.getFont("OpenSans+Cyberbit.ttf", 16.0f));
        this.windowSelect.setEditable(false);
        this.windowSelect.setBorder(new RoundBorder(UIConstants.COLOR_BUTTON_BLUE, 1, 10));
        this.windowSelect.setForeground(UIConstants.COLOR_BUTTON_BLUE);
        this.windowSelect.setBackground(UIConstants.COLOR_FORM_ELEMENT_INTERNAL);
        this.windowSelect.setUI(new SimpleButtonComboUI(new RoundedBorderFormatter(new RoundBorder(UIConstants.COLOR_BUTTON_BLUE, 1, 0)), this.resources, UIConstants.COLOR_SCROLL_TRACK, UIConstants.COLOR_SCROLL_THUMB));
        this.windowSelect.setFocusable(false);
        Accessible child = this.windowSelect.getAccessibleContext().getAccessibleChild(0);
        BasicComboPopup popup = (BasicComboPopup)child;
        JList<Object> list = popup.getList();
        list.setSelectionForeground(UIConstants.COLOR_BUTTON_BLUE);
        list.setSelectionBackground(UIConstants.COLOR_FORM_ELEMENT_INTERNAL);
        list.setBackground(UIConstants.COLOR_CENTRAL_BACK_OPAQUE);
        panel.add(this.windowSelect, new GridBagConstraints(1, 0, 1, 1, 0.5, 0.0, 10, 1, new Insets(8, 16, 8, 16), 0, 16));
        JLabel widthLabel = new JLabel(this.resources.getString("launcheroptions.video.windowSize.width", new String[0]));
        widthLabel.setFont(this.resources.getFont("OpenSans+Cyberbit.ttf", 16.0f));
        widthLabel.setForeground(UIConstants.COLOR_WHITE_TEXT);
        panel.add((Component)widthLabel, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.widthInput = new JTextField(3);
        this.widthInput.setFont(this.resources.getFont("OpenSans+Cyberbit.ttf", 16.0f));
        this.widthInput.setForeground(UIConstants.COLOR_BLUE);
        this.widthInput.setBackground(UIConstants.COLOR_FORM_ELEMENT_INTERNAL);
        this.widthInput.setBorder(new RoundBorder(UIConstants.COLOR_BUTTON_BLUE, 1, 8));
        this.widthInput.setCaretColor(UIConstants.COLOR_BLUE);
        this.widthInput.setText("800");
        panel.add((Component)this.widthInput, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(8, 6, 8, 16), 0, 0));
        JLabel heightLabel = new JLabel(this.resources.getString("launcheroptions.video.windowSize.height", new String[0]));
        heightLabel.setFont(this.resources.getFont("OpenSans+Cyberbit.ttf", 16.0f));
        heightLabel.setForeground(UIConstants.COLOR_WHITE_TEXT);
        panel.add((Component)heightLabel, new GridBagConstraints(4, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.heightInput = new JTextField(3);
        this.heightInput.setFont(this.resources.getFont("OpenSans+Cyberbit.ttf", 16.0f));
        this.heightInput.setForeground(UIConstants.COLOR_BLUE);
        this.heightInput.setBackground(UIConstants.COLOR_FORM_ELEMENT_INTERNAL);
        this.heightInput.setBorder(new RoundBorder(UIConstants.COLOR_BUTTON_BLUE, 1, 8));
        this.heightInput.setCaretColor(UIConstants.COLOR_BLUE);
        this.heightInput.setText("600");
        panel.add((Component)this.heightInput, new GridBagConstraints(5, 0, 1, 1, 0.0, 0.0, 17, 3, new Insets(8, 6, 8, 16), 0, 0));
        JLabel useStencilField = new JLabel(this.resources.getString("launcheroptions.video.stencil", new String[0]));
        useStencilField.setFont(this.resources.getFont("OpenSans+Cyberbit.ttf", 16.0f));
        useStencilField.setForeground(UIConstants.COLOR_WHITE_TEXT);
        panel.add((Component)useStencilField, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(10, 40, 0, 0), 0, 0));
        this.useStencil = new JComboBox();
        if (System.getProperty("os.name").toLowerCase(Locale.ROOT).contains("mac")) {
            this.useStencil.setUI(new MetalComboBoxUI());
        }
        this.useStencil.setFont(this.resources.getFont("OpenSans+Cyberbit.ttf", 16.0f));
        this.useStencil.setEditable(false);
        this.useStencil.setBorder(new RoundBorder(UIConstants.COLOR_BUTTON_BLUE, 1, 10));
        this.useStencil.setForeground(UIConstants.COLOR_BUTTON_BLUE);
        this.useStencil.setBackground(UIConstants.COLOR_FORM_ELEMENT_INTERNAL);
        this.useStencil.setUI(new SimpleButtonComboUI(new RoundedBorderFormatter(new RoundBorder(UIConstants.COLOR_BUTTON_BLUE, 1, 0)), this.resources, UIConstants.COLOR_SCROLL_TRACK, UIConstants.COLOR_SCROLL_THUMB));
        this.useStencil.setFocusable(false);
        child = this.useStencil.getAccessibleContext().getAccessibleChild(0);
        popup = (BasicComboPopup)child;
        list = popup.getList();
        list.setSelectionForeground(UIConstants.COLOR_BUTTON_BLUE);
        list.setSelectionBackground(UIConstants.COLOR_FORM_ELEMENT_INTERNAL);
        list.setBackground(UIConstants.COLOR_CENTRAL_BACK_OPAQUE);
        panel.add(this.useStencil, new GridBagConstraints(1, 1, 1, 1, 0.5, 0.0, 17, 1, new Insets(8, 16, 8, 16), 0, 16));
        JLabel stencilInfo = new JLabel(""){

            @Override
            public Dimension getMaximumSize() {
                return this.getMinimumSize();
            }

            @Override
            public Dimension getPreferredSize() {
                return this.getMinimumSize();
            }
        };
        stencilInfo.setFont(this.resources.getFont("OpenSans+Cyberbit.ttf", 12.0f));
        stencilInfo.setForeground(UIConstants.COLOR_WHITE_TEXT);
        stencilInfo.setText("<html><body style=\"font-family:" + stencilInfo.getFont().getFamily() + ";color:#D0D0D0\">" + this.resources.getString("launcheroptions.video.stencil.info", new String[0]) + "</body></html>");
        panel.add((Component)stencilInfo, new GridBagConstraints(2, 1, 4, 1, 0.0, 0.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
        panel.add(Box.createHorizontalStrut(60), new GridBagConstraints(7, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 30, 0));
        panel.add(Box.createGlue(), new GridBagConstraints(0, 2, 8, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
    }

    private void setupJavaOptionsPanel(JPanel panel) {
        panel.setLayout(new GridBagLayout());
        JLabel versionLabel = new JLabel(this.resources.getString("launcheroptions.java.version", new String[0]));
        versionLabel.setFont(this.resources.getFont("OpenSans+Cyberbit.ttf", 16.0f));
        versionLabel.setForeground(UIConstants.COLOR_WHITE_TEXT);
        panel.add((Component)versionLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 60, 0, 0), 0, 0));
        this.versionSelect = new JComboBox();
        if (System.getProperty("os.name").toLowerCase(Locale.ROOT).contains("mac")) {
            this.versionSelect.setUI(new MetalComboBoxUI());
        }
        this.versionSelect.setFont(this.resources.getFont("OpenSans+Cyberbit.ttf", 16.0f));
        this.versionSelect.setEditable(false);
        this.versionSelect.setBorder(new RoundBorder(UIConstants.COLOR_BUTTON_BLUE, 1, 10));
        this.versionSelect.setForeground(UIConstants.COLOR_BUTTON_BLUE);
        this.versionSelect.setBackground(UIConstants.COLOR_FORM_ELEMENT_INTERNAL);
        SimpleButtonComboUI ui = new SimpleButtonComboUI(new RoundedBorderFormatter(new RoundBorder(UIConstants.COLOR_BUTTON_BLUE, 1, 0)), this.resources, UIConstants.COLOR_SCROLL_TRACK, UIConstants.COLOR_SCROLL_THUMB);
        this.versionSelect.setUI(ui);
        this.versionSelect.setFocusable(false);
        Accessible child = this.versionSelect.getAccessibleContext().getAccessibleChild(0);
        BasicComboPopup popup = (BasicComboPopup)child;
        JList<Object> list = popup.getList();
        list.setSelectionForeground(UIConstants.COLOR_BUTTON_BLUE);
        list.setSelectionBackground(UIConstants.COLOR_FORM_ELEMENT_INTERNAL);
        list.setBackground(UIConstants.COLOR_CENTRAL_BACK_OPAQUE);
        panel.add(this.versionSelect, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(8, 16, 8, 8), 0, 16));
        RoundedButton otherVersionButton = new RoundedButton(this.resources.getString("launcheroptions.java.otherversion", new String[0]));
        otherVersionButton.setFont(this.resources.getFont("OpenSans+Cyberbit.ttf", 16.0f));
        otherVersionButton.setContentAreaFilled(false);
        otherVersionButton.setForeground(UIConstants.COLOR_BUTTON_BLUE);
        otherVersionButton.setHoverForeground(UIConstants.COLOR_BLUE);
        otherVersionButton.addActionListener(e -> this.selectOtherVersion());
        panel.add((Component)otherVersionButton, new GridBagConstraints(2, 0, 5, 1, 2.0, 0.0, 10, 1, new Insets(8, 8, 8, 80), 0, 0));
        JLabel memLabel = new JLabel(this.resources.getString("launcheroptions.java.memory", new String[0]));
        memLabel.setFont(this.resources.getFont("OpenSans+Cyberbit.ttf", 16.0f));
        memLabel.setForeground(UIConstants.COLOR_WHITE_TEXT);
        panel.add((Component)memLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 60, 0, 0), 0, 0));
        this.memSelect = new JComboBox();
        if (System.getProperty("os.name").toLowerCase(Locale.ROOT).contains("mac")) {
            this.memSelect.setUI(new MetalComboBoxUI());
        }
        this.memSelect.setFont(this.resources.getFont("OpenSans+Cyberbit.ttf", 16.0f));
        this.memSelect.setEditable(false);
        this.memSelect.setBorder(new RoundBorder(UIConstants.COLOR_BUTTON_BLUE, 1, 10));
        this.memSelect.setForeground(UIConstants.COLOR_BUTTON_BLUE);
        this.memSelect.setBackground(UIConstants.COLOR_FORM_ELEMENT_INTERNAL);
        ui = new SimpleButtonComboUI(new RoundedBorderFormatter(new RoundBorder(UIConstants.COLOR_BUTTON_BLUE, 1, 0)), this.resources, UIConstants.COLOR_SCROLL_TRACK, UIConstants.COLOR_SCROLL_THUMB);
        this.memSelect.setUI(ui);
        this.memSelect.setFocusable(false);
        child = this.memSelect.getAccessibleContext().getAccessibleChild(0);
        popup = (BasicComboPopup)child;
        list = popup.getList();
        list.setSelectionForeground(UIConstants.COLOR_BUTTON_BLUE);
        list.setSelectionBackground(UIConstants.COLOR_FORM_ELEMENT_INTERNAL);
        list.setBackground(UIConstants.COLOR_CENTRAL_BACK_OPAQUE);
        panel.add(this.memSelect, new GridBagConstraints(1, 1, 6, 1, 1.0, 0.0, 10, 1, new Insets(8, 16, 8, 80), 0, 16));
        JLabel argsLabel = new JLabel(this.resources.getString("launcheroptions.java.arguments", new String[0]));
        argsLabel.setFont(this.resources.getFont("OpenSans+Cyberbit.ttf", 16.0f));
        argsLabel.setForeground(UIConstants.COLOR_WHITE_TEXT);
        panel.add((Component)argsLabel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 60, 0, 0), 0, 0));
        this.javaArgs = new JTextArea(32, 4);
        this.javaArgs.setFont(this.resources.getFont("OpenSans+Cyberbit.ttf", 16.0f));
        this.javaArgs.setForeground(UIConstants.COLOR_BUTTON_BLUE);
        this.javaArgs.setBackground(UIConstants.COLOR_FORM_ELEMENT_INTERNAL);
        this.javaArgs.setBorder(new RoundBorder(UIConstants.COLOR_BUTTON_BLUE, 1, 8));
        this.javaArgs.setCaretColor(UIConstants.COLOR_BUTTON_BLUE);
        this.javaArgs.setMargin(new Insets(16, 4, 16, 4));
        this.javaArgs.setLineWrap(true);
        this.javaArgs.setWrapStyleWord(true);
        this.javaArgs.setSelectionColor(UIConstants.COLOR_BUTTON_BLUE);
        this.javaArgs.setSelectedTextColor(UIConstants.COLOR_FORM_ELEMENT_INTERNAL);
        panel.add((Component)this.javaArgs, new GridBagConstraints(1, 2, 6, 2, 0.0, 1.0, 10, 1, new Insets(8, 16, 6, 80), 0, 0));
        JLabel wrapperCmdLabel = new JLabel(this.resources.getString("launcheroptions.java.wrapper", new String[0]));
        wrapperCmdLabel.setFont(this.resources.getFont("OpenSans+Cyberbit.ttf", 16.0f));
        wrapperCmdLabel.setForeground(UIConstants.COLOR_WHITE_TEXT);
        panel.add((Component)wrapperCmdLabel, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 60, 0, 0), 0, 0));
        this.wrapperCommand = new JTextField("");
        this.wrapperCommand.setFont(this.resources.getFont("OpenSans+Cyberbit.ttf", 16.0f));
        this.wrapperCommand.setForeground(UIConstants.COLOR_BUTTON_BLUE);
        this.wrapperCommand.setBackground(UIConstants.COLOR_FORM_ELEMENT_INTERNAL);
        this.wrapperCommand.setBorder(new RoundBorder(UIConstants.COLOR_BUTTON_BLUE, 1, 8));
        this.wrapperCommand.setCaretColor(UIConstants.COLOR_BUTTON_BLUE);
        this.wrapperCommand.setSelectionColor(UIConstants.COLOR_BUTTON_BLUE);
        this.wrapperCommand.setSelectedTextColor(UIConstants.COLOR_FORM_ELEMENT_INTERNAL);
        panel.add((Component)this.wrapperCommand, new GridBagConstraints(1, 4, 2, 1, 1.0, 0.0, 10, 1, new Insets(8, 16, 8, 16), 0, 16));
        JLabel autoApprovalLabel = new JLabel(this.resources.getString("launcheroptions.java.autoApprove", new String[0]));
        autoApprovalLabel.setFont(this.resources.getFont("OpenSans+Cyberbit.ttf", 16.0f));
        autoApprovalLabel.setForeground(UIConstants.COLOR_WHITE_TEXT);
        panel.add((Component)autoApprovalLabel, new GridBagConstraints(0, 5, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 20, 0, 0), 0, 0));
        this.askFirstBox = new JCheckBox("", false);
        this.askFirstBox.setOpaque(false);
        this.askFirstBox.setHorizontalAlignment(4);
        this.askFirstBox.setBorder(BorderFactory.createEmptyBorder());
        this.askFirstBox.setIconTextGap(0);
        this.askFirstBox.setSelectedIcon(this.resources.getIcon("checkbox_closed.png"));
        this.askFirstBox.setIcon(this.resources.getIcon("checkbox_open.png"));
        this.askFirstBox.setFocusPainted(false);
        panel.add((Component)this.askFirstBox, new GridBagConstraints(1, 5, 6, 1, 0.0, 0.0, 17, 0, new Insets(8, 16, 8, 8), 0, 0));
        JLabel useMojangJavaLabel = new JLabel(this.resources.getString("launcheroptions.java.useMojangJava", new String[0]));
        useMojangJavaLabel.setFont(this.resources.getFont("OpenSans+Cyberbit.ttf", 16.0f));
        useMojangJavaLabel.setForeground(UIConstants.COLOR_WHITE_TEXT);
        panel.add((Component)useMojangJavaLabel, new GridBagConstraints(0, 6, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 20, 0, 0), 0, 0));
        this.useMojangJava = new JCheckBox("", false);
        this.useMojangJava.setOpaque(false);
        this.useMojangJava.setHorizontalAlignment(4);
        this.useMojangJava.setBorder(BorderFactory.createEmptyBorder());
        this.useMojangJava.setIconTextGap(0);
        this.useMojangJava.setSelectedIcon(this.resources.getIcon("checkbox_closed.png"));
        this.useMojangJava.setIcon(this.resources.getIcon("checkbox_open.png"));
        this.useMojangJava.setFocusPainted(false);
        panel.add((Component)this.useMojangJava, new GridBagConstraints(1, 6, 6, 1, 0.0, 0.0, 17, 0, new Insets(8, 16, 8, 8), 0, 0));
        panel.add(Box.createGlue(), new GridBagConstraints(4, 7, 1, 1, 1.0, 0.5, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
    }

    @Override
    public void relocalize(ResourceLoader loader) {
        this.resources = loader;
        this.resources.registerResource(this);
        this.getContentPane().removeAll();
        this.setLayout(null);
        this.initComponents();
        this.initControlValues();
        EventQueue.invokeLater(() -> {
            this.invalidate();
            this.repaint();
        });
    }
}

