/*
 * Decompiled with CFR 0.152.
 */
package net.technicpack.launcher.ui.components.discover;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.logging.Level;
import javax.swing.JPanel;
import net.technicpack.launcher.ui.components.discover.DiscoverLinkListener;
import net.technicpack.launcher.ui.components.discover.DiscoverResourceLoader;
import net.technicpack.launcher.ui.components.modpacks.ModpackSelector;
import net.technicpack.launchercore.install.LauncherDirectories;
import net.technicpack.platform.IPlatformApi;
import net.technicpack.ui.lang.ResourceLoader;
import net.technicpack.utilslib.Utils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.w3c.dom.Document;
import org.xhtmlrenderer.event.DocumentListener;
import org.xhtmlrenderer.resource.XMLResource;
import org.xhtmlrenderer.simple.XHTMLPanel;
import org.xhtmlrenderer.swing.DelegatingUserAgent;
import org.xhtmlrenderer.swing.FSMouseListener;
import org.xhtmlrenderer.swing.ImageResourceLoader;
import org.xhtmlrenderer.swing.SwingReplacedElementFactory;

public class DiscoverInfoPanel
extends JPanel {
    private final XHTMLPanel panel;
    private final LauncherDirectories directories;
    private final ResourceLoader resources;
    private ActionListener loadListener = null;

    public DiscoverInfoPanel(ResourceLoader loader, String discoverUrl, IPlatformApi platform, LauncherDirectories directories, ModpackSelector modpackSelector) {
        this.directories = directories;
        this.resources = loader;
        if (discoverUrl == null) {
            discoverUrl = "https://launcher.pokeland.cz/";
        }
        final String runnableAccessDiscover = discoverUrl;
        this.setLayout(new BorderLayout());
        this.panel = new XHTMLPanel();
        this.panel.setFont(this.resources.getFont("OpenSans+Cyberbit.ttf", 16.0f));
        this.panel.setDefaultFontFromComponent(true);
        this.panel.addDocumentListener(new DocumentListener(){
            private boolean hasReloaded = false;

            @Override
            public void documentStarted() {
            }

            @Override
            public void documentLoaded() {
                DiscoverInfoPanel.this.triggerLoadListener();
            }

            @Override
            public void onLayoutException(Throwable throwable) {
                Utils.getLogger().log(Level.SEVERE, "Discover page layout exception", throwable);
                if (!this.hasReloaded) {
                    this.hasReloaded = true;
                    EventQueue.invokeLater(() -> DiscoverInfoPanel.this.panel.setDocument(DiscoverInfoPanel.this.getDiscoverDocumentFromResource(), runnableAccessDiscover));
                }
            }

            @Override
            public void onRenderException(Throwable throwable) {
                Utils.getLogger().log(Level.SEVERE, "Discover page render exception", throwable);
                if (!this.hasReloaded) {
                    this.hasReloaded = true;
                    EventQueue.invokeLater(() -> DiscoverInfoPanel.this.panel.setDocument(DiscoverInfoPanel.this.getDiscoverDocumentFromResource(), runnableAccessDiscover));
                }
            }
        });
        for (FSMouseListener listener : this.panel.getMouseTrackingListeners()) {
            this.panel.removeMouseTrackingListener(listener);
        }
        this.panel.addMouseTrackingListener(new DiscoverLinkListener(platform, modpackSelector));
        DelegatingUserAgent uac = new DelegatingUserAgent();
        DiscoverResourceLoader imageLoader = new DiscoverResourceLoader();
        ((ImageResourceLoader)imageLoader).setRepaintListener(this.panel);
        ((ImageResourceLoader)imageLoader).clear();
        uac.setImageResourceLoader(imageLoader);
        this.panel.getSharedContext().getTextRenderer().setSmoothingThreshold(6.0f);
        this.panel.getSharedContext().setUserAgentCallback(uac);
        SwingReplacedElementFactory factory = new SwingReplacedElementFactory(this.panel, imageLoader);
        factory.reset();
        this.panel.getSharedContext().setReplacedElementFactory(factory);
        this.panel.getSharedContext().setFontMapping("Raleway", this.resources.getFont("Raleway+FireflySung.ttf", 12.0f));
        EventQueue.invokeLater(() -> {
            try {
                File localCache = new File(directories.getCacheDirectory(), "discover.html");
                this.panel.setDocument(this.getDiscoverDocument(runnableAccessDiscover, localCache), runnableAccessDiscover);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                this.triggerLoadListener();
            }
        });
        this.add((Component)this.panel, "Center");
    }

    public void setLoadListener(ActionListener listener) {
        this.loadListener = listener;
    }

    protected void triggerLoadListener() {
        final ActionListener deferredListener = this.loadListener;
        if (deferredListener != null) {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    deferredListener.actionPerformed(new ActionEvent(this, 0, "loaded"));
                }
            });
            this.loadListener = null;
        }
    }

    protected Document getDiscoverDocument(String url, File localCache) {
        Document doc = this.getDiscoverDocumentFromLiveSite(url, localCache);
        if (doc != null) {
            return doc;
        }
        if (localCache.exists() && (doc = this.getDiscoverDocumentFromLocalCache(localCache)) != null) {
            return doc;
        }
        return this.getDiscoverDocumentFromResource();
    }

    protected Document getDiscoverDocumentFromLiveSite(String url, File localCache) {
        try {
            HttpURLConnection conn = Utils.openHttpConnection(new URL(url));
            InputStream stream = conn.getInputStream();
            byte[] data = IOUtils.toByteArray(stream);
            Document doc = XMLResource.load(new ByteArrayInputStream(data)).getDocument();
            if (doc != null) {
                FileUtils.writeByteArrayToFile(localCache, data);
                return doc;
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        return null;
    }

    protected Document getDiscoverDocumentFromLocalCache(File localCache) {
        try {
            return XMLResource.load(FileUtils.openInputStream(localCache)).getDocument();
        }
        catch (IOException ex) {
            ex.printStackTrace();
            return null;
        }
    }

    protected Document getDiscoverDocumentFromResource() {
        return XMLResource.load(this.resources.getResourceAsStream("/discoverFallback.html")).getDocument();
    }
}

