/*
 * Decompiled with CFR 0.152.
 */
package net.technicpack.launcher.ui.components.modpacks;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.image.BufferedImage;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import net.technicpack.launcher.ui.UIConstants;
import net.technicpack.launcher.ui.controls.modpacks.ModpackTag;
import net.technicpack.launchercore.image.IImageJobListener;
import net.technicpack.launchercore.image.ImageJob;
import net.technicpack.launchercore.image.ImageRepository;
import net.technicpack.launchercore.install.ModpackVersion;
import net.technicpack.launchercore.modpacks.ModpackModel;
import net.technicpack.ui.lang.ResourceLoader;
import net.technicpack.utilslib.ImageUtils;

public class ModpackBanner
extends JPanel
implements IImageJobListener<ModpackModel> {
    private ResourceLoader resources;
    private ImageRepository<ModpackModel> iconRepo;
    private ModpackModel currentModpack;
    private ActionListener modpackOptionsListener;
    private JLabel modpackName;
    private JPanel modpackTags;
    private JLabel updateReady;
    private JLabel versionText;
    private JLabel installedVersion;
    private JLabel modpackIcon;
    private JLabel modpackOptions;

    public ModpackBanner(ResourceLoader resources, ImageRepository<ModpackModel> iconRepo, ActionListener modpackOptionsListener) {
        this.resources = resources;
        this.iconRepo = iconRepo;
        this.modpackOptionsListener = modpackOptionsListener;
        this.initComponents();
    }

    public void setModpack(ModpackModel modpack) {
        this.currentModpack = modpack;
        this.modpackName.setText(modpack.getDisplayName());
        this.modpackOptions.setVisible(!modpack.isLocalOnly() || modpack.getInstalledVersion() != null);
        ModpackVersion packVersion = modpack.getInstalledVersion();
        if (packVersion == null) {
            this.updateReady.setVisible(false);
            this.versionText.setVisible(false);
            this.installedVersion.setVisible(false);
        } else {
            this.updateReady.setVisible(modpack.hasRecommendedUpdate());
            this.versionText.setVisible(true);
            this.installedVersion.setVisible(true);
            this.installedVersion.setText(packVersion.getVersion());
        }
        ImageJob<ModpackModel> job = this.iconRepo.startImageJob(modpack);
        job.addJobListener(this);
        BufferedImage icon = job.getImage();
        if (icon.getWidth() > 50 || icon.getHeight() > 50) {
            icon = ImageUtils.scaleImage(icon, 50, 50);
        }
        this.modpackIcon.setIcon(new ImageIcon(icon));
        this.rebuildTags(modpack);
    }

    protected void rebuildTags(ModpackModel modpack) {
        this.modpackTags.removeAll();
        if (modpack.isOfficial()) {
            this.addTag("launcher.pack.tag.official", UIConstants.COLOR_BLUE);
        }
        if (modpack.getPackInfo() != null && modpack.getPackInfo().hasSolder()) {
            this.addTag("launcher.pack.tag.solder", UIConstants.COLOR_GREEN);
        }
        if (modpack.isServerPack()) {
            this.addTag("launcher.pack.tag.server", UIConstants.COLOR_SERVER);
        }
        if (modpack.isLocalOnly()) {
            this.addTag("launcher.pack.tag.offline", UIConstants.COLOR_RED);
        }
        if (this.modpackTags.getComponentCount() == 0) {
            this.modpackTags.add(Box.createRigidArea(new Dimension(8, 14)));
        }
        this.revalidate();
    }

    protected void addTag(String textString, Color lineColor) {
        this.modpackTags.add(Box.createRigidArea(new Dimension(5, 0)));
        ModpackTag tag = new ModpackTag(this.resources.getString(textString, new String[0]));
        tag.setForeground(Color.white);
        tag.setBackground(lineColor);
        tag.setFont(this.resources.getFont("OpenSans+Cyberbit.ttf", 11.0f));
        this.modpackTags.add(tag);
    }

    protected void openModpackOptions() {
        if (this.currentModpack != null) {
            this.modpackOptionsListener.actionPerformed(new ActionEvent(this.currentModpack, 0, ""));
        }
    }

    private void initComponents() {
        this.setLayout(new BoxLayout(this, 2));
        this.add(Box.createRigidArea(new Dimension(20, 10)));
        this.modpackIcon = new JLabel();
        this.modpackIcon.setIcon(this.resources.getIcon("icon.png"));
        this.add(this.modpackIcon);
        JPanel modpackNamePanel = new JPanel();
        modpackNamePanel.setOpaque(false);
        modpackNamePanel.setLayout(new BoxLayout(modpackNamePanel, 3));
        this.add(modpackNamePanel);
        this.modpackName = new JLabel("Modpack");
        this.modpackName.setForeground(UIConstants.COLOR_WHITE_TEXT);
        this.modpackName.setFont(this.resources.getFont("Raleway+FireflySung.ttf", 26.0f));
        this.modpackName.setHorizontalTextPosition(2);
        this.modpackName.setAlignmentX(0.0f);
        this.modpackName.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 0));
        this.modpackName.setOpaque(false);
        modpackNamePanel.add(this.modpackName);
        this.modpackTags = new JPanel();
        this.modpackTags.setLayout(new BoxLayout(this.modpackTags, 2));
        this.modpackTags.setBorder(BorderFactory.createEmptyBorder(0, 2, 2, 2));
        this.modpackTags.setOpaque(false);
        this.modpackTags.setAlignmentX(0.0f);
        modpackNamePanel.add(this.modpackTags);
        this.add(Box.createHorizontalGlue());
        JPanel packDoodads = new JPanel();
        packDoodads.setOpaque(false);
        packDoodads.setLayout(new BoxLayout(packDoodads, 3));
        JPanel versionPanel = new JPanel();
        versionPanel.setOpaque(false);
        versionPanel.setLayout(new FlowLayout(4));
        versionPanel.setAlignmentX(1.0f);
        packDoodads.add(versionPanel);
        versionPanel.add(Box.createRigidArea(new Dimension(1, 20)));
        this.updateReady = new JLabel();
        this.updateReady.setIcon(this.resources.getIcon("update_available.png"));
        this.updateReady.setHorizontalTextPosition(10);
        this.updateReady.setHorizontalAlignment(4);
        this.updateReady.setAlignmentX(1.0f);
        this.updateReady.setVisible(false);
        versionPanel.add(this.updateReady);
        this.versionText = new JLabel(this.resources.getString("launcher.packbanner.version", new String[0]));
        this.versionText.setFont(this.resources.getFont("OpenSans+Cyberbit.ttf", 14.0f));
        this.versionText.setForeground(UIConstants.COLOR_WHITE_TEXT);
        this.versionText.setHorizontalTextPosition(10);
        this.versionText.setHorizontalAlignment(4);
        this.versionText.setAlignmentX(1.0f);
        this.versionText.setVisible(false);
        versionPanel.add(this.versionText);
        this.installedVersion = new JLabel("1.0.7");
        this.installedVersion.setFont(this.resources.getFont("OpenSans+Cyberbit.ttf", 14.0f));
        this.installedVersion.setForeground(UIConstants.COLOR_WHITE_TEXT);
        this.installedVersion.setHorizontalTextPosition(10);
        this.installedVersion.setHorizontalAlignment(4);
        this.installedVersion.setAlignmentX(1.0f);
        this.installedVersion.setVisible(false);
        versionPanel.add(this.installedVersion);
        packDoodads.add(Box.createRigidArea(new Dimension(0, 5)));
        this.modpackOptions = new JLabel(this.resources.getString("launcher.packbanner.options", new String[0]));
        this.modpackOptions.setIcon(new ImageIcon(this.resources.colorImage(this.resources.getImage("options_cog.png"), UIConstants.COLOR_BUTTON_BLUE)));
        this.modpackOptions.setCursor(Cursor.getPredefinedCursor(12));
        Font font = this.resources.getFont("OpenSans+Cyberbit.ttf", 14.0f);
        this.modpackOptions.setFont(font);
        this.modpackOptions.setForeground(UIConstants.COLOR_BLUE);
        this.modpackOptions.setHorizontalTextPosition(10);
        this.modpackOptions.setHorizontalAlignment(4);
        this.modpackOptions.setAlignmentX(1.0f);
        this.modpackOptions.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
                ModpackBanner.this.openModpackOptions();
            }

            @Override
            public void mousePressed(MouseEvent e) {
            }

            @Override
            public void mouseReleased(MouseEvent e) {
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }
        });
        packDoodads.add(this.modpackOptions);
        this.add(packDoodads);
        this.add(Box.createRigidArea(new Dimension(8, 10)));
    }

    @Override
    public void jobComplete(ImageJob<ModpackModel> job) {
        if (this.currentModpack == job.getJobData()) {
            BufferedImage icon = job.getImage();
            if (icon.getWidth() > 50 || icon.getHeight() > 50) {
                icon = ImageUtils.scaleImage(icon, 50, 50);
            }
            this.modpackIcon.setIcon(new ImageIcon(icon));
            this.getParent().invalidate();
            EventQueue.invokeLater(() -> this.getParent().repaint());
        }
    }
}

