/*
 * Decompiled with CFR 0.152.
 */
package net.technicpack.launcher.ui.components.modpacks;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.SwingUtilities;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import net.technicpack.discord.IDiscordApi;
import net.technicpack.discord.io.Server;
import net.technicpack.launcher.ui.UIConstants;
import net.technicpack.launchercore.image.IImageJobListener;
import net.technicpack.launchercore.image.ImageJob;
import net.technicpack.launchercore.image.ImageRepository;
import net.technicpack.launchercore.modpacks.ModpackModel;
import net.technicpack.ui.controls.feeds.StatBox;
import net.technicpack.ui.controls.list.SimpleScrollbarUI;
import net.technicpack.ui.lang.ResourceLoader;
import net.technicpack.utilslib.DesktopUtils;
import net.technicpack.utilslib.ImageUtils;

public class ModpackDataDisplay
extends JPanel
implements IImageJobListener<ModpackModel> {
    private final ResourceLoader resources;
    private final ImageRepository<ModpackModel> logoRepo;
    private final IDiscordApi discordApi;
    private JPanel statBoxes;
    private JLabel titleLabel;
    private JTextPane description;
    private JButton packImage;
    private StatBox ratings;
    private StatBox runs;
    private StatBox installs;
    private JPanel discordPanel;
    private JButton discordLabel;
    private JButton countLabel;
    private List<JButton> discordButtons = new ArrayList<JButton>(3);
    private String packSiteUrl;
    private transient ModpackModel currentModpack;

    public ModpackDataDisplay(ResourceLoader resources, ImageRepository<ModpackModel> logoRepo, IDiscordApi api) {
        this.resources = resources;
        this.logoRepo = logoRepo;
        this.discordApi = api;
        this.initComponents();
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension size = super.getPreferredSize();
        return new Dimension(size.width, 225);
    }

    public void setModpack(ModpackModel modpack) {
        this.currentModpack = modpack;
        this.packSiteUrl = modpack.getWebSite();
        if (this.packSiteUrl == null) {
            this.packSiteUrl = "https://www.technicpack.net/";
        }
        this.titleLabel.setText(this.resources.getString("launcher.packstats.title", modpack.getDisplayName()));
        this.description.setText(modpack.getDescription());
        boolean wasVisible = this.ratings.isVisible();
        this.ratings.setVisible(!modpack.isOfficial());
        this.statBoxes.setVisible(!modpack.isOfficial());
        if (wasVisible == modpack.isOfficial()) {
            if (wasVisible) {
                this.statBoxes.remove(this.ratings);
            } else {
                this.statBoxes.add((Component)this.ratings, 0);
            }
        }
        this.ratings.setValue(modpack.getLikes());
        this.installs.setValue(modpack.getInstalls());
        this.runs.setValue(modpack.getRuns());
        ImageJob<ModpackModel> job = this.logoRepo.startImageJob(modpack);
        job.addJobListener(this);
        this.packImage.setIcon(new ImageIcon(ImageUtils.scaleImage(job.getImage(), 370, 220)));
        EventQueue.invokeLater(() -> {
            this.description.scrollRectToVisible(new Rectangle(new Dimension(1, 1)));
            this.repaint();
        });
        this.discordPanel.setVisible(false);
        if (modpack.getDiscordId() != null && !modpack.getDiscordId().isEmpty()) {
            this.discordApi.retrieveServer(modpack, modpack.getDiscordId(), this::updateDiscordComponents);
        }
    }

    private void initComponents() {
        BorderLayout packFeatureLayout = new BorderLayout();
        packFeatureLayout.setHgap(10);
        this.setLayout(packFeatureLayout);
        this.setOpaque(false);
        JPanel imagePanel = new JPanel();
        imagePanel.setOpaque(false);
        imagePanel.setAlignmentX(1.0f);
        imagePanel.setAlignmentY(0.0f);
        imagePanel.setBorder(BorderFactory.createEmptyBorder());
        imagePanel.setPreferredSize(new Dimension(370, 220));
        this.add((Component)imagePanel, "Before");
        this.packImage = new JButton(this.resources.getIcon("modpack/ModImageFiller.png"));
        this.packImage.setIcon(this.resources.getIcon("modpack/ModImageFiller.png"));
        this.packImage.setAlignmentX(1.0f);
        this.packImage.setPreferredSize(new Dimension(370, 220));
        this.packImage.setCursor(Cursor.getPredefinedCursor(12));
        this.packImage.setBorder(BorderFactory.createEmptyBorder());
        this.packImage.setContentAreaFilled(false);
        this.packImage.setFocusPainted(false);
        this.packImage.addActionListener(e -> DesktopUtils.browseUrl(this.packSiteUrl));
        imagePanel.add(this.packImage);
        JPanel packInfoPanel = new JPanel();
        packInfoPanel.setLayout(new GridBagLayout());
        packInfoPanel.setOpaque(false);
        packInfoPanel.setAlignmentY(0.0f);
        packInfoPanel.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.add((Component)packInfoPanel, "Center");
        this.statBoxes = new JPanel();
        this.statBoxes.setLayout(new GridLayout(1, 3, 5, 0));
        this.statBoxes.setOpaque(false);
        this.statBoxes.setBorder(BorderFactory.createEmptyBorder(5, 0, 0, 0));
        ActionListener listener = e -> DesktopUtils.browseUrl(this.packSiteUrl);
        this.ratings = new StatBox(this.resources, this.resources.getString("launcher.packstats.ratings", new String[0]), null);
        this.ratings.setBackground(UIConstants.COLOR_LIKES_BACK);
        this.ratings.setForeground(UIConstants.COLOR_WHITE_TEXT);
        this.ratings.addActionListener(listener);
        this.statBoxes.add(this.ratings);
        this.installs = new StatBox(this.resources, this.resources.getString("launcher.packstats.installs", new String[0]), null);
        this.installs.setBackground(UIConstants.COLOR_FEED_ITEM_BACK);
        this.installs.setForeground(UIConstants.COLOR_WHITE_TEXT);
        this.installs.addActionListener(listener);
        this.statBoxes.add(this.installs);
        this.runs = new StatBox(this.resources, this.resources.getString("launcher.packstats.runs", new String[0]), null);
        this.runs.setBackground(UIConstants.COLOR_FEED_ITEM_BACK);
        this.runs.setForeground(UIConstants.COLOR_WHITE_TEXT);
        this.runs.addActionListener(listener);
        this.statBoxes.add(this.runs);
        packInfoPanel.add((Component)this.statBoxes, new GridBagConstraints(0, 2, 2, 1, 0.0, 0.0, 15, 1, new Insets(0, 0, 0, 0), 0, 0));
        packInfoPanel.add(Box.createHorizontalGlue(), new GridBagConstraints(2, 2, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.discordPanel = new JPanel();
        this.discordPanel.setOpaque(false);
        this.discordPanel.setLayout(new GridBagLayout());
        JButton discordImage = new JButton(this.resources.getIcon("discord.png"));
        discordImage.setContentAreaFilled(false);
        discordImage.setFocusPainted(false);
        discordImage.setBorder(BorderFactory.createEmptyBorder());
        discordImage.setCursor(Cursor.getPredefinedCursor(12));
        this.discordPanel.add((Component)discordImage, new GridBagConstraints(0, 0, 1, 2, 0.0, 0.0, 17, 0, new Insets(2, 0, 0, 3), 0, 0));
        this.discordButtons.add(discordImage);
        this.discordLabel = new JButton(this.resources.getString("launcher.discord.join", new String[0]));
        this.discordLabel.setForeground(UIConstants.COLOR_WHITE_TEXT);
        this.discordLabel.setFont(this.resources.getFont("OpenSans+Cyberbit.ttf", 20.0f));
        this.discordLabel.setContentAreaFilled(false);
        this.discordLabel.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        this.discordLabel.setFocusPainted(false);
        this.discordLabel.setCursor(Cursor.getPredefinedCursor(12));
        this.discordPanel.add((Component)this.discordLabel, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.5, 16, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.discordButtons.add(this.discordLabel);
        this.countLabel = new JButton(this.resources.getString("launcher.discord.count", Integer.toString(0)));
        this.countLabel.setForeground(UIConstants.COLOR_WHITE_TEXT);
        this.countLabel.setFont(this.resources.getFont("OpenSans+Cyberbit.ttf", 14.0f));
        this.countLabel.setContentAreaFilled(false);
        this.countLabel.setBorder(BorderFactory.createEmptyBorder());
        this.countLabel.setFocusPainted(false);
        this.countLabel.setCursor(Cursor.getPredefinedCursor(12));
        this.discordPanel.add((Component)this.countLabel, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.5, 18, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.discordButtons.add(this.countLabel);
        packInfoPanel.add((Component)this.discordPanel, new GridBagConstraints(3, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 4), 0, 0));
        this.discordPanel.setVisible(false);
        this.titleLabel = new JLabel(this.resources.getString("launcher.packstats.title", "Modpack"));
        this.titleLabel.setFont(this.resources.getFont("Raleway+FireflySung.ttf", 24.0f, 1));
        this.titleLabel.setForeground(UIConstants.COLOR_WHITE_TEXT);
        this.titleLabel.setHorizontalAlignment(2);
        this.titleLabel.setHorizontalTextPosition(2);
        this.titleLabel.setAlignmentX(0.0f);
        this.titleLabel.setCursor(Cursor.getPredefinedCursor(12));
        this.titleLabel.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
                DesktopUtils.browseUrl(ModpackDataDisplay.this.packSiteUrl + "/about");
            }

            @Override
            public void mousePressed(MouseEvent e) {
            }

            @Override
            public void mouseReleased(MouseEvent e) {
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }
        });
        packInfoPanel.add((Component)this.titleLabel, new GridBagConstraints(0, 0, 4, 1, 1.0, 0.0, 11, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.description = new JTextPane();
        this.description.setFont(this.resources.getFont("OpenSans+Cyberbit.ttf", 14.0f));
        this.description.setOpaque(false);
        this.description.setEditable(false);
        this.description.setHighlighter(null);
        this.description.setAlignmentX(0.0f);
        this.description.setForeground(UIConstants.COLOR_WHITE_TEXT);
        this.description.setCursor(Cursor.getPredefinedCursor(12));
        SimpleAttributeSet attributes = new SimpleAttributeSet(this.description.getParagraphAttributes());
        StyleConstants.setLineSpacing(attributes, StyleConstants.getLineSpacing(attributes) * 1.3f);
        this.description.setParagraphAttributes(attributes, true);
        this.description.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
                DesktopUtils.browseUrl(ModpackDataDisplay.this.packSiteUrl + "/about");
            }

            @Override
            public void mousePressed(MouseEvent e) {
            }

            @Override
            public void mouseReleased(MouseEvent e) {
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }
        });
        this.description.setBorder(BorderFactory.createEmptyBorder(8, 8, 8, 8));
        JScrollPane scrollPane = new JScrollPane(this.description, 20, 31);
        scrollPane.setBorder(BorderFactory.createEmptyBorder());
        scrollPane.setOpaque(false);
        scrollPane.getViewport().setOpaque(false);
        scrollPane.getVerticalScrollBar().setUI(new SimpleScrollbarUI(UIConstants.COLOR_SCROLL_TRACK, UIConstants.COLOR_SCROLL_THUMB));
        scrollPane.getVerticalScrollBar().setPreferredSize(new Dimension(10, 10));
        JPanel scrollHostPanel = new JPanel();
        scrollHostPanel.setBackground(UIConstants.COLOR_FEED_BACK);
        scrollHostPanel.setLayout(new BorderLayout());
        scrollHostPanel.add((Component)scrollPane, "Center");
        scrollPane.getVerticalScrollBar().addAdjustmentListener(e -> this.repaint());
        packInfoPanel.add((Component)scrollHostPanel, new GridBagConstraints(0, 1, 4, 1, 1.0, 1.0, 11, 1, new Insets(5, 0, 0, 0), 0, 0));
    }

    @Override
    public void jobComplete(ImageJob<ModpackModel> job) {
        if (job.getJobData() == this.currentModpack) {
            this.packImage.setIcon(new ImageIcon(ImageUtils.scaleImage(job.getImage(), 370, 220)));
        }
    }

    private void updateDiscordComponents(ModpackModel pack, Server server) {
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(() -> this.updateDiscordComponents(pack, server));
            return;
        }
        if (this.currentModpack != pack) {
            return;
        }
        if (server == null || server.getInviteLink() == null || server.getInviteLink().isEmpty()) {
            this.discordPanel.setVisible(false);
            return;
        }
        this.countLabel.setText(this.resources.getString("launcher.discord.count", Integer.toString(server.getPresenceCount())));
        if (pack.isOfficial()) {
            this.discordLabel.setText(this.resources.getString("launcher.discord.official", new String[0]));
        } else {
            this.discordLabel.setText(this.resources.getString("launcher.discord.join", new String[0]));
        }
        for (JButton discordButton : this.discordButtons) {
            for (ActionListener actionListener : discordButton.getActionListeners()) {
                discordButton.removeActionListener(actionListener);
            }
            discordButton.addActionListener(e -> DesktopUtils.browseUrl(server.getInviteLink()));
        }
        this.discordPanel.setVisible(true);
    }
}

