/*
 * Decompiled with CFR 0.152.
 */
package net.technicpack.launcher.ui.controls;

import java.awt.EventQueue;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.BorderFactory;
import javax.swing.DefaultButtonModel;
import javax.swing.JLabel;
import net.technicpack.launcher.ui.UIConstants;
import net.technicpack.ui.lang.ResourceLoader;

public class HeaderTab
extends JLabel
implements MouseListener {
    private boolean isActive;
    private DefaultButtonModel model = new DefaultButtonModel();

    public HeaderTab(String text, ResourceLoader resources) {
        super(text);
        this.setIsActive(false);
        this.setFont(resources.getFont("Raleway+FireflySung.ttf", 26.0f));
        this.setForeground(UIConstants.COLOR_WHITE_TEXT);
        this.setBackground(UIConstants.COLOR_BLUE_DARKER);
        this.setBorder(BorderFactory.createEmptyBorder(20, 18, 20, 18));
        this.addMouseListener(this);
    }

    public boolean isActive() {
        return this.isActive;
    }

    public void setIsActive(boolean isActive) {
        this.isActive = isActive;
        this.setOpaque(isActive);
        EventQueue.invokeLater(this::repaint);
    }

    public void addActionListener(ActionListener listener) {
        this.model.addActionListener(listener);
    }

    public String getActionCommand() {
        return this.model.getActionCommand();
    }

    public ActionListener[] getActionListeners() {
        return this.model.getActionListeners();
    }

    public void removeActionListener(ActionListener listener) {
        this.model.removeActionListener(listener);
    }

    public void setActionCommand(String command) {
        this.model.setActionCommand(command);
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.model.setPressed(true);
        this.model.setArmed(true);
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.model.setPressed(false);
        this.model.setArmed(false);
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        this.model.setRollover(true);
    }

    @Override
    public void mouseExited(MouseEvent e) {
        this.model.setRollover(false);
    }
}

