/*
 * Decompiled with CFR 0.152.
 */
package net.technicpack.launcher.ui.controls;

import java.awt.Color;
import java.awt.image.BufferedImage;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import net.technicpack.launcher.ui.UIConstants;
import net.technicpack.launchercore.auth.IUserType;
import net.technicpack.launchercore.image.IImageJobListener;
import net.technicpack.launchercore.image.ImageJob;
import net.technicpack.launchercore.image.ImageRepository;
import net.technicpack.ui.lang.ResourceLoader;
import net.technicpack.utilslib.ImageUtils;

public class UserWidget
extends JPanel
implements IImageJobListener<IUserType> {
    private ImageRepository<IUserType> skinRepository;
    private JLabel userName;
    private JLabel avatar;
    private IUserType currentUser;

    public UserWidget(ResourceLoader resources, ImageRepository<IUserType> skinRepository) {
        this.skinRepository = skinRepository;
        this.initComponents(resources);
    }

    private void initComponents(ResourceLoader resources) {
        String preText;
        this.setOpaque(false);
        this.avatar = new JLabel();
        this.avatar.setIcon(resources.getIcon("news/authorHelm.png"));
        this.add(this.avatar);
        String fullText = resources.getString("launcher.user.logged", new String[0]);
        int endPreText = fullText.indexOf("{0}");
        int startPostText = endPreText + 3;
        String postText = "";
        if (endPreText < 0) {
            preText = fullText;
        } else {
            preText = endPreText == 0 ? "" : fullText.substring(0, endPreText);
            postText = startPostText >= fullText.length() ? "" : fullText.substring(startPostText);
        }
        JLabel staticText = new JLabel(preText);
        staticText.setForeground(UIConstants.COLOR_WHITE_TEXT);
        staticText.setFont(resources.getFont("Raleway+FireflySung.ttf", 15.0f));
        if (!preText.isEmpty()) {
            this.add(staticText);
        }
        this.userName = new JLabel("");
        this.userName.setForeground(UIConstants.COLOR_WHITE_TEXT);
        this.userName.setBackground(Color.white);
        this.userName.setFont(resources.getFont("Raleway+FireflySung.ttf", 17.0f, 1));
        this.add(this.userName);
        staticText = new JLabel(postText);
        staticText.setForeground(UIConstants.COLOR_WHITE_TEXT);
        staticText.setFont(resources.getFont("Raleway+FireflySung.ttf", 15.0f));
        if (!postText.isEmpty()) {
            this.add(staticText);
        }
    }

    public void setUser(IUserType user) {
        this.currentUser = user;
        this.userName.setText(user.getDisplayName());
        ImageJob<IUserType> job = this.skinRepository.startImageJob(this.currentUser);
        job.addJobListener(this);
        this.refreshFace(job.getImage());
    }

    private void refreshFace(BufferedImage image) {
        this.avatar.setIcon(new ImageIcon(ImageUtils.scaleWithAspectWidth(image, 30)));
    }

    @Override
    public void jobComplete(ImageJob<IUserType> job) {
        if (job.getJobData() == this.currentUser) {
            this.refreshFace(job.getImage());
        }
    }
}

