/*
 * Decompiled with CFR 0.152.
 */
package net.technicpack.launchercore.install.tasks;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.util.Set;
import java.util.SortedMap;
import java.util.stream.Collectors;
import net.technicpack.launchercore.exception.DownloadException;
import net.technicpack.launchercore.install.InstallTasksQueue;
import net.technicpack.launchercore.install.tasks.ListenerTask;
import net.technicpack.launchercore.install.verifiers.IFileVerifier;
import net.technicpack.utilslib.Utils;
import org.apache.commons.compress.compressors.CompressorException;
import org.apache.commons.compress.compressors.CompressorInputStream;
import org.apache.commons.compress.compressors.CompressorStreamFactory;
import org.apache.commons.compress.compressors.CompressorStreamProvider;

public class DownloadFileTask<T>
extends ListenerTask<T> {
    private static final Set<String> AVAILABLE_DECOMPRESSORS;
    private final String url;
    private final File destination;
    private final String taskDescription;
    private final IFileVerifier fileVerifier;
    private boolean executable;
    private String decompressor;

    public DownloadFileTask(String url, File destination, IFileVerifier verifier) {
        this(url, destination, verifier, destination.getName());
    }

    public DownloadFileTask(String url, File destination, IFileVerifier verifier, String taskDescription) {
        this.url = url;
        this.destination = destination;
        this.fileVerifier = verifier;
        this.taskDescription = taskDescription;
    }

    protected File getDestination() {
        return this.destination;
    }

    public void setDecompressor(String decompressor) throws DownloadException {
        if (!AVAILABLE_DECOMPRESSORS.contains(decompressor.toLowerCase())) {
            throw new DownloadException(String.format("Decompressor '%s' is not available", decompressor));
        }
        this.decompressor = decompressor;
    }

    @Override
    public String getTaskDescription() {
        return this.taskDescription;
    }

    @Override
    public void runTask(InstallTasksQueue<T> queue) throws IOException, InterruptedException {
        File tempDestination;
        IFileVerifier downloadFileVerifier;
        boolean needsDecompression;
        super.runTask(queue);
        boolean bl = needsDecompression = this.decompressor != null;
        if (needsDecompression) {
            downloadFileVerifier = null;
            tempDestination = new File(this.destination + ".temp");
        } else {
            downloadFileVerifier = this.fileVerifier;
            tempDestination = this.destination;
        }
        Utils.downloadFile(this.url, tempDestination.getName(), tempDestination.getAbsolutePath(), null, downloadFileVerifier, this);
        if (needsDecompression) {
            this.decompress(tempDestination);
        }
        if (!this.destination.exists()) {
            throw new DownloadException("Failed to download " + this.destination.getName() + ".");
        }
        if (this.executable && !this.destination.setExecutable(true)) {
            throw new DownloadException("Failed to set " + this.destination.getName() + " as executable");
        }
    }

    private void decompress(File tempDestination) throws IOException {
        Utils.getLogger().fine("Decompressing " + tempDestination.getAbsolutePath() + " using " + this.decompressor);
        try (FileInputStream fis = new FileInputStream(tempDestination);
             CompressorInputStream cis = new CompressorStreamFactory().createCompressorInputStream(this.decompressor, fis);
             FileOutputStream fos = new FileOutputStream(this.destination);){
            int n;
            byte[] buffer = new byte[65536];
            while ((n = cis.read(buffer)) != -1) {
                fos.write(buffer, 0, n);
            }
        }
        catch (CompressorException e) {
            throw new DownloadException("Failed to decompress " + tempDestination.getName(), e);
        }
        if (this.fileVerifier.isFileValid(this.destination)) {
            try {
                Files.delete(tempDestination.toPath());
            }
            catch (IOException e) {
                throw new DownloadException("Failed to delete temporary file " + tempDestination.getAbsolutePath(), e);
            }
        }
        try {
            Files.delete(this.destination.toPath());
        }
        catch (IOException e) {
            throw new DownloadException("Failed to delete broken downloaded file " + this.destination.getAbsolutePath(), e);
        }
        throw new DownloadException("Failed to download " + this.destination.getAbsolutePath());
    }

    public DownloadFileTask<T> withExecutable() {
        this.executable = true;
        return this;
    }

    static {
        SortedMap<String, CompressorStreamProvider> availableProviders = CompressorStreamFactory.findAvailableCompressorInputStreamProviders();
        AVAILABLE_DECOMPRESSORS = availableProviders.keySet().stream().map(String::toLowerCase).collect(Collectors.toSet());
    }
}

