/*
 * Decompiled with CFR 0.152.
 */
package net.technicpack.launchercore.install.tasks;

import java.io.File;
import java.io.IOException;
import java.util.Objects;
import net.technicpack.launchercore.install.ITasksQueue;
import net.technicpack.launchercore.install.InstallTasksQueue;
import net.technicpack.launchercore.install.tasks.DownloadFileTask;
import net.technicpack.launchercore.install.tasks.IInstallTask;
import net.technicpack.launchercore.install.tasks.UnzipFileTask;
import net.technicpack.launchercore.install.verifiers.IFileVerifier;
import net.technicpack.utilslib.IZipFileFilter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EnsureFileTask<T>
implements IInstallTask<T> {
    private final File targetFile;
    private final ITasksQueue<T> downloadTaskQueue;
    @NotNull
    private final String friendlyFileName;
    private File zipExtractionDirectory;
    private String sourceUrl;
    private IFileVerifier fileVerifier;
    private ITasksQueue<T> copyTaskQueue;
    @Nullable
    private IZipFileFilter filter = null;
    private boolean executable = false;
    private String downloadDecompressor;

    public EnsureFileTask(@NotNull ITasksQueue<T> downloadQueue, @NotNull File target) {
        this.targetFile = target;
        this.friendlyFileName = target.getName();
        this.downloadTaskQueue = downloadQueue;
    }

    @Override
    @NotNull
    public String getTaskDescription() {
        return String.format("Verifying %s", this.targetFile.getName());
    }

    @Override
    public float getTaskProgress() {
        return 0.0f;
    }

    @Override
    public void runTask(InstallTasksQueue<T> queue) throws IOException {
        Objects.requireNonNull(this.downloadTaskQueue, "Download task queue must be set.");
        Objects.requireNonNull(this.targetFile, "Target file must be set.");
        Objects.requireNonNull(this.friendlyFileName, "Friendly file name must be set.");
        if (this.zipExtractionDirectory != null) {
            this.copyTaskQueue.addNextTask(new UnzipFileTask(this.targetFile, this.zipExtractionDirectory, this.filter));
        }
        if (this.sourceUrl != null && (!this.targetFile.exists() || this.fileVerifier != null && !this.fileVerifier.isFileValid(this.targetFile))) {
            DownloadFileTask downloadFileTask = new DownloadFileTask(this.sourceUrl, this.targetFile, this.fileVerifier, this.friendlyFileName);
            if (this.executable) {
                downloadFileTask.withExecutable();
            }
            if (this.downloadDecompressor != null) {
                downloadFileTask.setDecompressor(this.downloadDecompressor);
            }
            this.downloadTaskQueue.addNextTask(downloadFileTask);
        }
    }

    @NotNull
    public EnsureFileTask<T> withExecutableBitSet() {
        this.executable = true;
        return this;
    }

    @NotNull
    public EnsureFileTask<T> withDownloadDecompressor(String downloadDecompressor) {
        this.downloadDecompressor = downloadDecompressor;
        return this;
    }

    @NotNull
    public EnsureFileTask<T> withVerifier(IFileVerifier fileVerifier) {
        this.fileVerifier = fileVerifier;
        return this;
    }

    @NotNull
    public EnsureFileTask<T> withExtractTo(@NotNull File directory, @NotNull ITasksQueue<T> copyQueue) {
        Objects.requireNonNull(directory, "Extraction directory must be set.");
        Objects.requireNonNull(copyQueue, "Copy task queue must be set.");
        this.zipExtractionDirectory = directory;
        this.copyTaskQueue = copyQueue;
        return this;
    }

    @NotNull
    public EnsureFileTask<T> withZipFilter(IZipFileFilter filter) {
        this.filter = filter;
        return this;
    }

    @NotNull
    public EnsureFileTask<T> withUrl(String url) {
        this.sourceUrl = url;
        return this;
    }
}

