/*
 * Decompiled with CFR 0.152.
 */
package net.technicpack.launchercore.install.verifiers;

import java.io.File;
import net.technicpack.launchercore.install.verifiers.IFileVerifier;
import net.technicpack.utilslib.CryptoUtils;
import net.technicpack.utilslib.Utils;

public class MD5FileVerifier
implements IFileVerifier {
    private String md5Hash;

    public MD5FileVerifier(String md5Hash) {
        this.md5Hash = md5Hash;
    }

    @Override
    public boolean isFileValid(File file) {
        if (this.md5Hash == null || this.md5Hash.isEmpty()) {
            return false;
        }
        String resultMD5 = CryptoUtils.getMD5(file);
        boolean hashMatches = this.md5Hash.equalsIgnoreCase(resultMD5);
        if (!hashMatches) {
            Utils.getLogger().warning("MD5 verification for " + file + " failed. Expected " + this.md5Hash + ", got " + resultMD5);
        }
        return hashMatches;
    }
}

