/*
 * Decompiled with CFR 0.152.
 */
package net.technicpack.launchercore.install.verifiers;

import java.io.File;
import net.technicpack.launchercore.install.verifiers.IFileVerifier;
import net.technicpack.utilslib.CryptoUtils;
import net.technicpack.utilslib.Utils;

public class SHA256FileVerifier
implements IFileVerifier {
    private String sha256Hash;

    public SHA256FileVerifier(String sha256Hash) {
        this.sha256Hash = sha256Hash;
    }

    @Override
    public boolean isFileValid(File file) {
        if (this.sha256Hash == null || this.sha256Hash.isEmpty()) {
            return false;
        }
        String resultSha256 = CryptoUtils.getSHA256(file);
        boolean hashMatches = this.sha256Hash.equalsIgnoreCase(resultSha256);
        if (!hashMatches) {
            Utils.getLogger().warning("SHA256 verification for " + file + " failed. Expected " + this.sha256Hash + ", got " + resultSha256);
        }
        return hashMatches;
    }
}

