/*
 * Decompiled with CFR 0.152.
 */
package net.technicpack.launchercore.install.verifiers;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import java.io.File;
import java.nio.charset.StandardCharsets;
import java.util.logging.Level;
import net.technicpack.launchercore.install.verifiers.IFileVerifier;
import net.technicpack.utilslib.Utils;
import org.apache.commons.io.FileUtils;

public class ValidJsonFileVerifier
implements IFileVerifier {
    private Gson validatingGson;

    public ValidJsonFileVerifier(Gson validatingGson) {
        this.validatingGson = validatingGson;
    }

    @Override
    public boolean isFileValid(File file) {
        try {
            String json = FileUtils.readFileToString(file, StandardCharsets.UTF_8);
            JsonObject obj = this.validatingGson.fromJson(json, JsonObject.class);
            return obj != null;
        }
        catch (Exception ex) {
            Utils.getLogger().log(Level.SEVERE, "An exception was raised while verifying " + file.getAbsolutePath() + "- this probably just means the file is invalid, in which case this is not an error:", ex);
            return false;
        }
    }
}

