/*
 * Decompiled with CFR 0.152.
 */
package net.technicpack.launchercore.launch;

import java.util.concurrent.CompletableFuture;
import net.technicpack.launchercore.launch.ProcessExitListener;
import net.technicpack.launchercore.launch.ProcessMonitorThread;

public class GameProcess {
    private final Process process;
    private final CompletableFuture<Void> exitFuture = new CompletableFuture();
    private final ProcessMonitorThread monitorThread;

    public GameProcess(Process process, String userAccessToken) {
        this.process = process;
        this.monitorThread = new ProcessMonitorThread(this, userAccessToken);
        this.monitorThread.start();
    }

    public void setExitListener(ProcessExitListener exitListener) {
        this.exitFuture.thenRun(exitListener::onProcessExit);
    }

    public Process getProcess() {
        return this.process;
    }

    public void setProcessExited() {
        this.exitFuture.complete(null);
    }
}

