/*
 * Decompiled with CFR 0.152.
 */
package net.technicpack.launchercore.launch;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import net.technicpack.launchercore.launch.GameProcess;
import net.technicpack.utilslib.Utils;

public class ProcessMonitorThread
extends Thread {
    private final GameProcess process;
    private final String userAccessToken;
    private final Logger logger;

    public ProcessMonitorThread(GameProcess process, String userAccessToken) {
        super("ProcessMonitorThread");
        this.process = process;
        this.userAccessToken = userAccessToken;
        this.logger = Utils.getLogger();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Pattern redactPattern = Pattern.compile("(?i)" + Pattern.quote(this.userAccessToken));
        boolean shouldRedact = !this.userAccessToken.equals("0");
        try (InputStreamReader reader = new InputStreamReader(this.process.getProcess().getInputStream());
             BufferedReader buf = new BufferedReader(reader);){
            String line;
            StringBuilder lineBuilder = new StringBuilder(1024);
            while ((line = buf.readLine()) != null) {
                if (shouldRedact) {
                    line = redactPattern.matcher(line).replaceAll("USER_ACCESS_TOKEN");
                }
                lineBuilder.setLength(0);
                lineBuilder.append(' ').append(line);
                this.logger.info(lineBuilder.toString());
            }
        }
        catch (IOException ex) {
            this.logger.log(Level.SEVERE, "Error reading process output - process will continue running but output will not be logged", ex);
        }
        try {
            this.process.getProcess().waitFor();
            this.logger.info(String.format("Process exited with code %d", this.process.getProcess().exitValue()));
        }
        catch (InterruptedException e) {
            this.logger.log(Level.SEVERE, "Interrupted while waiting for process to exit", e);
            this.interrupt();
        }
        finally {
            this.process.setProcessExited();
        }
    }
}

