/*
 * Decompiled with CFR 0.152.
 */
package net.technicpack.launchercore.launch.java;

import java.io.File;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import net.technicpack.launchercore.launch.java.IJavaRuntime;
import net.technicpack.launchercore.launch.java.version.CurrentJavaRuntime;

public class JavaVersionRepository {
    public static final String VERSION_DEFAULT = "default";
    public static final String VERSION_LATEST_64BIT = "64bit";
    private final Map<File, IJavaRuntime> loadedVersions = new HashMap<File, IJavaRuntime>();
    private final Collection<IJavaRuntime> versionCache = new LinkedList<IJavaRuntime>();
    private IJavaRuntime selectedVersion;

    public JavaVersionRepository() {
        CurrentJavaRuntime currentVersion = new CurrentJavaRuntime();
        this.selectedVersion = currentVersion;
        this.loadedVersions.put(null, currentVersion);
        this.versionCache.add(currentVersion);
    }

    public boolean addVersion(IJavaRuntime version) {
        if (this.loadedVersions.containsKey(version.getExecutableFile()) || this.versionCache.contains(version)) {
            return false;
        }
        if (!version.isValid()) {
            return false;
        }
        File path = version.getExecutableFile();
        this.loadedVersions.put(path, version);
        this.versionCache.add(version);
        if (this.selectedVersion == null) {
            this.selectedVersion = version;
        }
        return true;
    }

    public IJavaRuntime getBest64BitVersion() {
        return this.loadedVersions.values().stream().filter(IJavaRuntime::is64Bit).max(Comparator.comparing(IJavaRuntime::getVersion)).orElse(null);
    }

    public Collection<IJavaRuntime> getVersions() {
        return this.loadedVersions.values();
    }

    public IJavaRuntime getSelectedVersion() {
        return this.selectedVersion;
    }

    public void selectVersion(String version, boolean is64Bit) {
        this.selectedVersion = this.getVersion(version, is64Bit);
    }

    public void setSelectedVersion(IJavaRuntime version) {
        if (version == null) {
            throw new IllegalArgumentException("version cannot be null");
        }
        if (!this.loadedVersions.containsValue(version)) {
            throw new IllegalArgumentException("version is not loaded");
        }
        this.selectedVersion = version;
    }

    public IJavaRuntime getDefaultVersion() {
        return this.loadedVersions.get(null);
    }

    public IJavaRuntime getVersion(String version, boolean is64Bit) {
        if (version == null || version.isEmpty() || version.equals(VERSION_DEFAULT)) {
            return this.getDefaultVersion();
        }
        if (version.equals(VERSION_LATEST_64BIT)) {
            IJavaRuntime best64BitVersion = this.getBest64BitVersion();
            if (best64BitVersion == null) {
                best64BitVersion = this.getDefaultVersion();
            }
            return best64BitVersion;
        }
        for (IJavaRuntime checkVersion : this.versionCache) {
            if (!version.equals(checkVersion.getVersion()) || is64Bit != checkVersion.is64Bit()) continue;
            return checkVersion;
        }
        IJavaRuntime specifiedVersion = this.loadedVersions.get(new File(version));
        if (specifiedVersion == null) {
            specifiedVersion = this.getDefaultVersion();
        }
        return specifiedVersion;
    }
}

