/*
 * Decompiled with CFR 0.152.
 */
package net.technicpack.launchercore.launch.java.source;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import net.technicpack.launchercore.launch.java.IJavaRuntime;
import net.technicpack.launchercore.launch.java.IVersionSource;
import net.technicpack.launchercore.launch.java.JavaVersionRepository;
import net.technicpack.launchercore.launch.java.version.FileBasedJavaRuntime;
import net.technicpack.utilslib.Utils;

public class FileJavaSource
implements IVersionSource,
Serializable {
    private transient File loadedFile;
    private List<FileBasedJavaRuntime> versions = new ArrayList<FileBasedJavaRuntime>();

    protected FileJavaSource(File loadFile) {
        this.loadedFile = loadFile;
    }

    protected void setLoadedFile(File loadedFile) {
        this.loadedFile = loadedFile;
    }

    @Override
    public void enumerateVersions(JavaVersionRepository repository) {
        if (this.versions.removeIf(version -> !repository.addVersion((IJavaRuntime)version))) {
            this.save();
        }
    }

    public void addVersion(FileBasedJavaRuntime version) {
        this.versions.add(version);
        this.save();
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static FileJavaSource load(File file) {
        if (file == null || !file.exists()) {
            return new FileJavaSource(file);
        }
        try (FileInputStream fis = new FileInputStream(file);){
            FileJavaSource fileJavaSource;
            try (InputStreamReader reader = new InputStreamReader((InputStream)fis, StandardCharsets.UTF_8);){
                FileJavaSource source = Utils.getGson().fromJson((Reader)reader, FileJavaSource.class);
                source.setLoadedFile(file);
                fileJavaSource = source;
            }
            return fileJavaSource;
        }
        catch (IOException ex) {
            Utils.getLogger().log(Level.SEVERE, "Failed to load Java versions file", ex);
            return new FileJavaSource(file);
        }
    }

    public void save() {
        try (FileOutputStream fos = new FileOutputStream(this.loadedFile);
             OutputStreamWriter writer = new OutputStreamWriter((OutputStream)fos, StandardCharsets.UTF_8);){
            Utils.getGson().toJson((Object)this, (Appendable)writer);
        }
        catch (IOException ex) {
            Utils.getLogger().log(Level.SEVERE, "Failed to save Java versions file", ex);
        }
    }
}

