/*
 * Decompiled with CFR 0.152.
 */
package net.technicpack.launchercore.logging;

import io.sentry.Sentry;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.SwingUtilities;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import net.technicpack.ui.components.ConsoleFrame;
import net.technicpack.utilslib.Utils;

public class ConsoleHandler
extends Handler {
    private final ConsoleFrame consoleFrame;
    private final BlockingQueue<LogRecord> logQueue = new LinkedBlockingQueue<LogRecord>();
    private final Thread workerThread;
    private volatile boolean running = true;
    private static final int MAX_DOC_CHARS = 300000;
    private static final int MAX_LINES = 2500;

    public ConsoleHandler(ConsoleFrame consoleFrame) {
        this.consoleFrame = consoleFrame;
        Utils.getLogger().info("Console Mode Activated");
        this.workerThread = new Thread(this::processLogs, "ConsoleHandler-Worker");
        this.workerThread.setDaemon(true);
        this.workerThread.start();
    }

    @Override
    public void publish(LogRecord record) {
        if (!this.isLoggable(record)) {
            return;
        }
        this.logQueue.offer(record);
    }

    private AttributeSet getAttributes(LogRecord record, String msg) {
        AttributeSet attributes = this.consoleFrame.getDefaultAttributes();
        Level level = record.getLevel();
        if (msg.startsWith("(!!)")) {
            attributes = this.consoleFrame.getHighlightedAttributes();
        } else if (level == Level.SEVERE) {
            attributes = this.consoleFrame.getErrorAttributes();
        } else if (level == Level.WARNING) {
            attributes = this.consoleFrame.getWarnAttributes();
        } else if (level.intValue() < Level.INFO.intValue()) {
            attributes = this.consoleFrame.getDebugAttributes();
        }
        return attributes;
    }

    private void processLogs() {
        try {
            while (this.running) {
                LogRecord first = this.logQueue.take();
                ArrayList<LogRecord> batch = new ArrayList<LogRecord>();
                batch.add(first);
                this.logQueue.drainTo(batch);
                SwingUtilities.invokeLater(() -> this.writeBatchToUI(batch));
            }
        }
        catch (InterruptedException ignored) {
            Thread.currentThread().interrupt();
        }
    }

    private void trimDocument(Document doc) {
        try {
            int finalTrimOffset;
            Element trimLine;
            Element root = doc.getDefaultRootElement();
            int lineCount = root.getElementCount();
            int excessLines = lineCount - 2500;
            int offsetByLines = -1;
            if (excessLines > 0 && (trimLine = root.getElement(excessLines - 1)) != null) {
                offsetByLines = trimLine.getEndOffset();
            }
            int offsetByChars = -1;
            if (doc.getLength() > 300000) {
                for (int i = 0; i < root.getElementCount(); ++i) {
                    Element line = root.getElement(i);
                    if (line.getEndOffset() < doc.getLength() - 300000) continue;
                    offsetByChars = line.getEndOffset();
                    break;
                }
            }
            if ((finalTrimOffset = Math.max(offsetByLines, offsetByChars)) > 0 && finalTrimOffset < doc.getLength()) {
                doc.remove(0, finalTrimOffset);
            }
        }
        catch (BadLocationException e) {
            Sentry.captureException(e);
        }
    }

    private boolean isScrollAtBottom(JScrollPane scrollPane) {
        JScrollBar vertical = scrollPane.getVerticalScrollBar();
        int bottom = vertical.getMaximum() - vertical.getVisibleAmount();
        return vertical.getValue() >= bottom - 30;
    }

    private void writeBatchToUI(List<LogRecord> batch) {
        Document document = this.consoleFrame.getDocument();
        for (LogRecord record : batch) {
            String msg;
            try {
                msg = this.getFormatter().format(record);
            }
            catch (Exception e) {
                Sentry.captureException(e);
                continue;
            }
            AttributeSet attributes = this.getAttributes(record, msg);
            String writeText = msg.replace("\n\n", "\n");
            try {
                int offset = document.getLength();
                document.insertString(offset, writeText, attributes);
            }
            catch (BadLocationException e) {
                Sentry.captureException(e);
            }
        }
        this.trimDocument(document);
        JScrollPane scrollPane = this.consoleFrame.getScrollPane();
        boolean shouldScroll = true;
        SwingUtilities.invokeLater(() -> {
            try {
                JTextPane textPane = this.consoleFrame.getTextPane();
                Rectangle rect = textPane.modelToView(document.getLength());
                if (rect != null) {
                    textPane.scrollRectToVisible(rect);
                }
            }
            catch (BadLocationException e) {
                Sentry.captureException(e);
            }
        });
    }

    @Override
    public void flush() {
    }

    @Override
    public void close() {
        this.running = false;
        this.workerThread.interrupt();
    }
}

