/*
 * Decompiled with CFR 0.152.
 */
package net.technicpack.launchercore.logging;

import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.StreamHandler;
import net.technicpack.utilslib.Utils;

public class RotatingFileHandler
extends StreamHandler {
    private final SimpleDateFormat dateFormat;
    private final String logPathFormat;
    private String currentLogPath;

    public RotatingFileHandler(String logPathFormat) {
        this.logPathFormat = logPathFormat;
        this.dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        this.currentLogPath = this.calculatePath();
        try {
            this.setOutputStream(new FileOutputStream(this.currentLogPath, true));
        }
        catch (FileNotFoundException ex) {
            Utils.getLogger().log(Level.SEVERE, ex.getMessage(), ex);
        }
    }

    private String calculatePath() {
        return String.format(this.logPathFormat, this.dateFormat.format(new Date()));
    }

    private void changeFileIfNeeded() {
        String newPath = this.calculatePath();
        if (!this.currentLogPath.equals(newPath)) {
            String oldPath = this.currentLogPath;
            this.currentLogPath = newPath;
            try {
                this.close();
                this.setOutputStream(new FileOutputStream(this.currentLogPath, true));
                super.publish(new LogRecord(Level.INFO, "Continued from " + oldPath));
            }
            catch (FileNotFoundException ex) {
                Utils.getLogger().log(Level.SEVERE, ex.getMessage(), ex);
            }
        }
    }

    @Override
    public synchronized void publish(LogRecord record) {
        this.changeFileIfNeeded();
        super.publish(record);
        this.flush();
    }
}

