/*
 * Decompiled with CFR 0.152.
 */
package net.technicpack.launchercore.modpacks;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.technicpack.launchercore.modpacks.IModpackContainer;
import net.technicpack.launchercore.modpacks.ModpackModel;

public class MemoryModpackContainer
implements IModpackContainer {
    private Map<String, ModpackModel> modpacks = new HashMap<String, ModpackModel>();
    private Map<IModpackContainer, IModpackContainer> passthroughContainers = new ConcurrentHashMap<IModpackContainer, IModpackContainer>();

    @Override
    public void clear() {
        this.modpacks.clear();
        for (IModpackContainer container : this.passthroughContainers.values()) {
            container.clear();
        }
    }

    @Override
    public void addModpackToContainer(ModpackModel modpack) {
        this.modpacks.put(modpack.getName(), modpack);
        for (IModpackContainer container : this.passthroughContainers.values()) {
            container.addModpackToContainer(modpack);
        }
    }

    @Override
    public void replaceModpackInContainer(ModpackModel modpack) {
        if (this.modpacks.containsKey(modpack.getName())) {
            this.modpacks.put(modpack.getName(), modpack);
        }
        for (IModpackContainer container : this.passthroughContainers.values()) {
            container.replaceModpackInContainer(modpack);
        }
    }

    @Override
    public void refreshComplete() {
        for (IModpackContainer container : this.passthroughContainers.values()) {
            container.refreshComplete();
        }
    }

    public void addPassthroughContainer(IModpackContainer container) {
        this.passthroughContainers.put(container, container);
    }

    public void removePassthroughContainer(IModpackContainer container) {
        this.passthroughContainers.remove(container);
    }

    public Collection<ModpackModel> getModpacks() {
        return this.modpacks.values();
    }
}

