/*
 * Decompiled with CFR 0.152.
 */
package net.technicpack.launchercore.modpacks;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Comparator;
import java.util.logging.Level;
import net.technicpack.launchercore.launch.java.IJavaRuntime;
import net.technicpack.launchercore.launch.java.JavaVersionRepository;
import net.technicpack.utilslib.Memory;
import net.technicpack.utilslib.Utils;

public class RunData
implements Serializable {
    private String java;
    private String memory;
    private transient long memoryLong = -1L;

    private RunData() {
    }

    public String getJava() {
        return this.java;
    }

    public long getMemory() {
        if (this.memoryLong != -1L) {
            return this.memoryLong;
        }
        if (this.memory == null || this.memory.isEmpty()) {
            this.memoryLong = 0L;
        } else {
            try {
                if (this.memory.charAt(0) == '-') {
                    throw new NumberFormatException("Invalid runData memory specified, cannot be negative");
                }
                this.memoryLong = Long.parseLong(this.memory);
            }
            catch (NumberFormatException ex) {
                Utils.getLogger().log(Level.WARNING, "Exception caught when parsing runData memory", ex);
                this.memoryLong = 0L;
            }
        }
        return this.memoryLong;
    }

    public Memory getMemoryObject() {
        return this.getMemorySetting(this.getMemory());
    }

    public static boolean isJavaVersionAtLeast(String testString, String compareString) {
        String[] compareVersion = compareString.split("[._]");
        String[] testVersion = testString.split("[._]");
        int compareLength = Math.min(compareVersion.length, testVersion.length);
        for (int i = 0; i < compareLength; ++i) {
            int testVal;
            int refVal = Integer.parseInt(compareVersion[i]);
            if (refVal == (testVal = Integer.parseInt(testVersion[i]))) continue;
            return testVal > refVal;
        }
        if (compareVersion.length == testVersion.length) {
            return true;
        }
        return compareVersion.length < testVersion.length;
    }

    public boolean isJavaValid(String testString) {
        String compareString = this.java;
        if (compareString == null || compareString.isEmpty()) {
            compareString = "1.6";
        }
        return RunData.isJavaVersionAtLeast(testString, compareString);
    }

    public boolean isMemoryValid(long memory) {
        return this.getMemory() <= memory;
    }

    public boolean isRunDataValid(long memory, String java, boolean usingMojangJava) {
        return this.isMemoryValid(memory) && (usingMojangJava || this.isJavaValid(java));
    }

    public IJavaRuntime getValidJavaVersion(JavaVersionRepository repository) {
        boolean requires64Bit = this.getMemory() > 1024L;
        IJavaRuntime best64Bit = repository.getBest64BitVersion();
        if (best64Bit != null && this.isJavaValid(best64Bit.getVersion())) {
            return best64Bit;
        }
        if (best64Bit == null && requires64Bit) {
            return null;
        }
        IJavaRuntime bestVersion = null;
        for (IJavaRuntime version : repository.getVersions()) {
            if (!this.isJavaValid(version.getVersion()) || requires64Bit && !version.is64Bit()) continue;
            bestVersion = version;
        }
        return bestVersion;
    }

    public Memory getValidMemory(JavaVersionRepository repository) {
        boolean can64Bit = repository.getBest64BitVersion() != null;
        Memory required = this.getMemorySetting(this.getMemory());
        Memory available = Memory.getClosestAvailableMemory(required, can64Bit);
        if (available.getMemoryMB() < required.getMemoryMB()) {
            return null;
        }
        return available;
    }

    private Memory getMemorySetting(long memory) {
        for (Memory setting : Memory.memoryOptions) {
            if (setting.getMemoryMB() < memory) continue;
            return setting;
        }
        Memory maxMemoryOption = Arrays.stream(Memory.memoryOptions).max(Comparator.comparingLong(Memory::getMemoryMB)).orElseThrow(() -> new RuntimeException("No memory options available"));
        Utils.getLogger().log(Level.WARNING, "Invalid runData memory value specified (" + memory + " MB); using maximum possible instead (" + maxMemoryOption.getMemoryMB() + " MB)");
        return maxMemoryOption;
    }
}

