/*
 * Decompiled with CFR 0.152.
 */
package net.technicpack.launchercore.modpacks.resources;

import java.io.File;
import java.io.IOException;
import java.util.logging.Level;
import net.technicpack.launchercore.image.IImageStore;
import net.technicpack.launchercore.modpacks.ModpackModel;
import net.technicpack.launchercore.modpacks.resources.resourcetype.IModpackResourceType;
import net.technicpack.rest.io.Resource;
import net.technicpack.utilslib.Utils;

public class PackImageStore
implements IImageStore<ModpackModel> {
    private IModpackResourceType resourceType;

    public PackImageStore(IModpackResourceType resourceType) {
        this.resourceType = resourceType;
    }

    @Override
    public boolean canDownloadImage(ModpackModel key, File target) {
        Resource res = this.resourceType.getResource(key);
        return res != null && res.getUrl() != null && !res.getUrl().isEmpty();
    }

    @Override
    public void downloadImage(ModpackModel key, File target) {
        Resource res = this.resourceType.getResource(key);
        if (res == null || res.getUrl() == null || res.getUrl().isEmpty()) {
            return;
        }
        try {
            Utils.downloadFile(res.getUrl(), null, target.getAbsolutePath());
        }
        catch (InterruptedException interruptedException) {
        }
        catch (IOException e) {
            Utils.getLogger().log(Level.INFO, "Error downloading pack resource " + res.getUrl() + " for pack " + key.getName(), e);
        }
    }

    @Override
    public String getJobKey(ModpackModel key) {
        return "pack-resource-" + key.getName() + "-" + this.resourceType.getImageName();
    }

    @Override
    public boolean canRetry(ModpackModel key) {
        return key.getPackInfo() == null || !key.getPackInfo().isComplete();
    }
}

