/*
 * Decompiled with CFR 0.152.
 */
package net.technicpack.minecraftcore.install;

import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.stream.Stream;
import net.technicpack.launchercore.modpacks.ModpackModel;
import net.technicpack.utilslib.IZipFileFilter;
import net.technicpack.utilslib.Utils;

public class ModpackZipFilter
implements IZipFileFilter {
    private final ModpackModel pack;
    private final Path cacheDirPath;
    private final Path binPath;
    private final ArrayList<Path> allowedInBinDir;

    public ModpackZipFilter(ModpackModel pack) {
        this.pack = pack;
        this.cacheDirPath = this.pack.getCacheDir().toPath();
        this.binPath = this.pack.getBinDir().toPath();
        this.allowedInBinDir = new ArrayList();
        Stream.of("modpack.jar", "version.json", "runData").forEach(filename -> this.allowedInBinDir.add(this.binPath.resolve((String)filename)));
    }

    private void warnAboutFile(File file) {
        Utils.getLogger().log(Level.WARNING, "Modpack " + this.pack.getName() + " tried to extract reserved file " + file.getAbsolutePath());
    }

    @Override
    public boolean shouldExtract(String fileName) {
        File file = new File(this.pack.getInstalledDirectory(), fileName);
        Path path = file.toPath().normalize();
        if (path.startsWith(this.binPath) && !path.equals(this.binPath) && !this.allowedInBinDir.contains(path)) {
            this.warnAboutFile(file);
            return false;
        }
        if (path.startsWith(this.cacheDirPath)) {
            this.warnAboutFile(file);
            return false;
        }
        return true;
    }
}

