/*
 * Decompiled with CFR 0.152.
 */
package net.technicpack.minecraftcore.install.tasks;

import java.io.File;
import java.io.IOException;
import net.technicpack.launchercore.exception.DownloadException;
import net.technicpack.launchercore.install.ITasksQueue;
import net.technicpack.launchercore.install.InstallTasksQueue;
import net.technicpack.launchercore.install.tasks.DownloadFileTask;
import net.technicpack.launchercore.install.tasks.IInstallTask;
import net.technicpack.launchercore.install.verifiers.SHA1FileVerifier;
import net.technicpack.launchercore.modpacks.ModpackModel;
import net.technicpack.minecraftcore.MojangUtils;
import net.technicpack.minecraftcore.install.tasks.InstallJavaRuntimeTask;
import net.technicpack.minecraftcore.mojang.java.JavaRuntime;
import net.technicpack.minecraftcore.mojang.java.JavaRuntimesIndex;
import net.technicpack.minecraftcore.mojang.version.MojangVersion;
import net.technicpack.minecraftcore.mojang.version.io.Download;
import net.technicpack.minecraftcore.mojang.version.io.VersionJavaInfo;

public class EnsureJavaRuntimeManifestTask
implements IInstallTask<MojangVersion> {
    private final File runtimesDirectory;
    private final ModpackModel modpack;
    private final ITasksQueue<MojangVersion> fetchJavaManifest;
    private final ITasksQueue<MojangVersion> examineJavaQueue;
    private final ITasksQueue<MojangVersion> downloadJavaQueue;

    public EnsureJavaRuntimeManifestTask(File runtimesDirectory, ModpackModel modpack, ITasksQueue<MojangVersion> fetchJavaManifest, ITasksQueue<MojangVersion> examineJavaQueue, ITasksQueue<MojangVersion> downloadJavaQueue) {
        this.runtimesDirectory = runtimesDirectory;
        this.modpack = modpack;
        this.fetchJavaManifest = fetchJavaManifest;
        this.examineJavaQueue = examineJavaQueue;
        this.downloadJavaQueue = downloadJavaQueue;
    }

    @Override
    public String getTaskDescription() {
        return "Retrieving Java runtime manifest";
    }

    @Override
    public float getTaskProgress() {
        return 0.0f;
    }

    @Override
    public void runTask(InstallTasksQueue<MojangVersion> queue) throws IOException {
        MojangVersion version = queue.getMetadata();
        VersionJavaInfo runtimeInfo = version.getMojangRuntimeInformation();
        if (runtimeInfo == null) {
            return;
        }
        String runtimeName = runtimeInfo.getComponent();
        JavaRuntimesIndex availableRuntimes = MojangUtils.getJavaRuntimesIndex();
        if (availableRuntimes == null) {
            throw new DownloadException("Failed to get Mojang JRE information");
        }
        JavaRuntime manifest = availableRuntimes.getRuntimeForCurrentOS(runtimeName);
        if (manifest == null) {
            throw new DownloadException("A Mojang JRE is not available for the current OS");
        }
        Download runtimeDownload = manifest.getManifest();
        File output = new File(this.runtimesDirectory + File.separator + "manifests", runtimeName + ".json");
        new File(output.getParent()).mkdirs();
        SHA1FileVerifier fileVerifier = new SHA1FileVerifier(runtimeDownload.getSha1());
        if (!output.exists() || !fileVerifier.isFileValid(output)) {
            this.fetchJavaManifest.addTask(new DownloadFileTask(runtimeDownload.getUrl(), output, fileVerifier));
        }
        this.examineJavaQueue.addTask(new InstallJavaRuntimeTask(this.modpack, this.runtimesDirectory, output, runtimeInfo, this.examineJavaQueue, this.downloadJavaQueue));
    }
}

