/*
 * Decompiled with CFR 0.152.
 */
package net.technicpack.minecraftcore.install.tasks;

import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import net.technicpack.launchercore.exception.DownloadException;
import net.technicpack.launchercore.install.ITasksQueue;
import net.technicpack.launchercore.install.InstallTasksQueue;
import net.technicpack.launchercore.install.tasks.EnsureFileTask;
import net.technicpack.launchercore.install.tasks.EnsureLinkedFileTask;
import net.technicpack.launchercore.install.tasks.IInstallTask;
import net.technicpack.launchercore.install.verifiers.SHA1FileVerifier;
import net.technicpack.launchercore.launch.java.version.FileBasedJavaRuntime;
import net.technicpack.launchercore.modpacks.ModpackModel;
import net.technicpack.minecraftcore.MojangUtils;
import net.technicpack.minecraftcore.mojang.java.JavaRuntimeFileType;
import net.technicpack.minecraftcore.mojang.java.JavaRuntimeManifest;
import net.technicpack.minecraftcore.mojang.version.MojangVersion;
import net.technicpack.minecraftcore.mojang.version.io.Download;
import net.technicpack.minecraftcore.mojang.version.io.VersionJavaInfo;
import net.technicpack.utilslib.OperatingSystem;
import org.apache.commons.io.FileUtils;

public class InstallJavaRuntimeTask
implements IInstallTask<MojangVersion> {
    private final ModpackModel modpack;
    private final File runtimesDirectory;
    private final File runtimeManifestFile;
    private final VersionJavaInfo runtimeInfo;
    private final ITasksQueue<MojangVersion> examineJavaQueue;
    private final ITasksQueue<MojangVersion> downloadJavaQueue;

    public InstallJavaRuntimeTask(ModpackModel modpack, File runtimesDirectory, File runtimeManifestFile, VersionJavaInfo runtimeInfo, ITasksQueue<MojangVersion> examineJavaQueue, ITasksQueue<MojangVersion> downloadJavaQueue) {
        this.modpack = modpack;
        this.runtimesDirectory = runtimesDirectory;
        this.runtimeManifestFile = runtimeManifestFile;
        this.runtimeInfo = runtimeInfo;
        this.examineJavaQueue = examineJavaQueue;
        this.downloadJavaQueue = downloadJavaQueue;
    }

    @Override
    public String getTaskDescription() {
        return "Installing Java runtime";
    }

    @Override
    public float getTaskProgress() {
        return 0.0f;
    }

    private void ensurePathIsSafe(File root, File target) {
        if (!target.toPath().normalize().startsWith(root.toPath())) {
            throw new RuntimeException("JRE entry attempted to be placed outside of JRE root folder: " + target.getAbsolutePath());
        }
    }

    @Override
    public void runTask(InstallTasksQueue<MojangVersion> queue) throws IOException {
        String json = FileUtils.readFileToString(this.runtimeManifestFile, StandardCharsets.UTF_8);
        JavaRuntimeManifest manifest = MojangUtils.getGson().fromJson(json, JavaRuntimeManifest.class);
        if (manifest == null) {
            throw new DownloadException("The Java runtime manifest is invalid.");
        }
        File runtimeRoot = new File(this.runtimesDirectory, this.runtimeInfo.getComponent()).getAbsoluteFile();
        this.ensurePathIsSafe(this.runtimesDirectory, runtimeRoot);
        runtimeRoot.mkdirs();
        manifest.getFiles().forEach((path, runtimeFile) -> {
            if (runtimeFile.getType() == JavaRuntimeFileType.DIRECTORY) {
                File dir = new File(runtimeRoot, (String)path);
                this.ensurePathIsSafe(runtimeRoot, dir);
                dir.mkdirs();
            }
        });
        manifest.getFiles().forEach((path, runtimeFile) -> {
            if (runtimeFile.getType() == JavaRuntimeFileType.FILE) {
                File target = new File(runtimeRoot, (String)path);
                this.ensurePathIsSafe(runtimeRoot, target);
                target.getParentFile().mkdirs();
                Download rawDownload = runtimeFile.getDownloads().getRaw();
                Download lzmaDownload = runtimeFile.getDownloads().getLzma();
                SHA1FileVerifier verifier = new SHA1FileVerifier(rawDownload.getSha1());
                boolean useLzma = lzmaDownload != null && !lzmaDownload.getUrl().isEmpty() && (double)lzmaDownload.getSize() / (double)rawDownload.getSize() <= 0.66;
                String downloadUrl = useLzma ? lzmaDownload.getUrl() : rawDownload.getUrl();
                EnsureFileTask<MojangVersion> ensureFileTask = new EnsureFileTask<MojangVersion>(this.downloadJavaQueue, target).withUrl(downloadUrl).withVerifier(verifier);
                if (useLzma) {
                    ensureFileTask.withDownloadDecompressor("lzma");
                }
                if (runtimeFile.isExecutable()) {
                    ensureFileTask.withExecutableBitSet();
                }
                this.examineJavaQueue.addTask(ensureFileTask);
            }
        });
        manifest.getFiles().forEach((path, runtimeFile) -> {
            if (runtimeFile.getType() == JavaRuntimeFileType.LINK) {
                File link = new File(runtimeRoot, (String)path);
                this.ensurePathIsSafe(runtimeRoot, link);
                File target = new File(link, runtimeFile.getTarget());
                this.ensurePathIsSafe(runtimeRoot, target);
                this.downloadJavaQueue.addTask(new EnsureLinkedFileTask(link, target));
            }
        });
        OperatingSystem os = OperatingSystem.getOperatingSystem();
        Path runtimeExecutable = os == OperatingSystem.WINDOWS ? runtimeRoot.toPath().resolve("bin/javaw.exe") : (os == OperatingSystem.OSX ? runtimeRoot.toPath().resolve("jre.bundle/Contents/Home/bin/java") : runtimeRoot.toPath().resolve("bin/java"));
        FileBasedJavaRuntime runtime = new FileBasedJavaRuntime(runtimeExecutable);
        MojangVersion version = queue.getMetadata();
        version.setJavaRuntime(runtime);
    }
}

