/*
 * Decompiled with CFR 0.152.
 */
package net.technicpack.minecraftcore.microsoft.auth;

import java.io.Serializable;
import net.technicpack.launchercore.auth.IUserType;
import net.technicpack.launchercore.auth.UserModel;
import net.technicpack.launchercore.exception.AuthenticationException;
import net.technicpack.minecraftcore.microsoft.auth.model.MinecraftProfile;
import net.technicpack.minecraftcore.microsoft.auth.model.XboxMinecraftResponse;

public class MicrosoftUser
implements IUserType,
Serializable {
    public static final String USER_TYPE = "msa";
    private String id;
    private String username;
    private String accessToken = "0";
    private transient boolean isOffline = false;

    private MicrosoftUser() {
    }

    public MicrosoftUser(XboxMinecraftResponse authResponse, MinecraftProfile profile) {
        this.setProfile(profile);
        this.setAuthToken(authResponse);
    }

    public MicrosoftUser(String id, String username) {
        this.id = id;
        this.username = username;
        this.isOffline = true;
    }

    @Override
    public String getUserType() {
        return USER_TYPE;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getUsername() {
        return this.username;
    }

    @Override
    public String getDisplayName() {
        return this.username;
    }

    @Override
    public String getAccessToken() {
        return this.accessToken;
    }

    @Override
    public String getSessionId() {
        return "token:" + this.accessToken + ":" + this.id;
    }

    @Override
    public String getMCUserType() {
        return USER_TYPE;
    }

    @Override
    public String getUserProperties() {
        return "{}";
    }

    @Override
    public boolean isOffline() {
        return this.isOffline;
    }

    @Override
    public void login(UserModel userModel) throws AuthenticationException {
        userModel.getMicrosoftAuthenticator().refreshSession(this);
    }

    public void setAuthToken(XboxMinecraftResponse authResponse) {
        this.accessToken = authResponse.accessToken;
    }

    public void setProfile(MinecraftProfile profile) {
        this.id = profile.id;
        this.username = profile.name;
    }

    public String toString() {
        return this.getDisplayName();
    }
}

