/*
 * Decompiled with CFR 0.152.
 */
package net.technicpack.minecraftcore.mojang.java;

import com.google.gson.annotations.SerializedName;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.technicpack.minecraftcore.mojang.java.JavaRuntime;
import net.technicpack.utilslib.JavaUtils;
import net.technicpack.utilslib.OSUtils;
import net.technicpack.utilslib.OperatingSystem;

public class JavaRuntimesIndex {
    @SerializedName(value="linux")
    private Map<String, List<JavaRuntime>> linux64;
    @SerializedName(value="linux-i386")
    private Map<String, List<JavaRuntime>> linux32;
    @SerializedName(value="mac-os")
    private Map<String, List<JavaRuntime>> mac;
    @SerializedName(value="mac-os-arm64")
    private Map<String, List<JavaRuntime>> macArm64;
    @SerializedName(value="windows-arm64")
    private Map<String, List<JavaRuntime>> windowsArm64;
    @SerializedName(value="windows-x64")
    private Map<String, List<JavaRuntime>> windows64;
    @SerializedName(value="windows-x86")
    private Map<String, List<JavaRuntime>> windows32;

    private JavaRuntimesIndex() {
    }

    public Map<String, List<JavaRuntime>> getRuntimesForCurrentOS() {
        switch (OperatingSystem.getOperatingSystem()) {
            case WINDOWS: {
                if (JavaUtils.isArm64()) {
                    return this.windowsArm64;
                }
                if (OSUtils.is64BitOS()) {
                    return this.windows64;
                }
                return this.windows32;
            }
            case OSX: {
                if (JavaUtils.isArm64()) {
                    HashMap<String, List<JavaRuntime>> combinedMac = new HashMap<String, List<JavaRuntime>>(this.mac);
                    this.macArm64.forEach((key, value) -> {
                        if (!value.isEmpty()) {
                            combinedMac.put((String)key, (List<JavaRuntime>)value);
                        }
                    });
                    return combinedMac;
                }
                return this.mac;
            }
            case LINUX: {
                if (OSUtils.is64BitOS()) {
                    return this.linux64;
                }
                return this.linux32;
            }
        }
        return Collections.emptyMap();
    }

    public JavaRuntime getRuntimeForCurrentOS(String runtimeName) {
        Map<String, List<JavaRuntime>> availableRuntimes = this.getRuntimesForCurrentOS();
        if (availableRuntimes == null || availableRuntimes.isEmpty()) {
            return null;
        }
        return availableRuntimes.get(runtimeName).get(0);
    }
}

