/*
 * Decompiled with CFR 0.152.
 */
package net.technicpack.minecraftcore.mojang.version.builder;

import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.List;
import net.technicpack.minecraftcore.MojangUtils;
import net.technicpack.minecraftcore.mojang.version.MojangVersion;
import net.technicpack.minecraftcore.mojang.version.MojangVersionBuilder;
import net.technicpack.minecraftcore.mojang.version.builder.MojangVersionRetriever;
import org.apache.commons.io.FileUtils;

public class FileVersionBuilder
implements MojangVersionBuilder {
    private File version;
    private MojangVersionRetriever retriever;
    private List<MojangVersionRetriever> fallbackRetrievers;

    public FileVersionBuilder(File version, MojangVersionRetriever retriever, List<MojangVersionRetriever> fallbackRetrievers) {
        this.version = version;
        this.retriever = retriever;
        this.fallbackRetrievers = fallbackRetrievers;
    }

    @Override
    public MojangVersion buildVersionFromKey(String key) throws InterruptedException, IOException {
        File target = this.version;
        if (key != null) {
            if (this.version.isDirectory()) {
                String targetFile = key + ".json";
                target = new File(this.version, targetFile);
            }
            if (this.retriever != null) {
                this.retriever.retrieveVersion(target, key);
            }
            if (this.fallbackRetrievers != null) {
                for (MojangVersionRetriever fallbackRetriever : this.fallbackRetrievers) {
                    if (target.exists()) break;
                    fallbackRetriever.retrieveVersion(target, key);
                }
            }
        }
        if (!target.exists()) {
            return null;
        }
        String json = FileUtils.readFileToString(target, StandardCharsets.UTF_8);
        return MojangUtils.parseVersionJson(json);
    }
}

