/*
 * Decompiled with CFR 0.152.
 */
package net.technicpack.minecraftcore.mojang.version.chain;

import java.io.IOException;
import java.util.regex.Pattern;
import net.technicpack.minecraftcore.mojang.version.MojangVersion;
import net.technicpack.minecraftcore.mojang.version.MojangVersionBuilder;
import net.technicpack.minecraftcore.mojang.version.chain.VersionChain;

public class ChainVersionBuilder
implements MojangVersionBuilder {
    private static final Pattern MINECRAFT_VERSION_PATTERN = Pattern.compile("^\\d++(\\.\\d++)++$");
    private MojangVersionBuilder primaryVersionBuilder;
    private MojangVersionBuilder chainedVersionBuilder;

    public ChainVersionBuilder(MojangVersionBuilder primaryVersionBuilder, MojangVersionBuilder chainedVersionBuilder) {
        this.primaryVersionBuilder = primaryVersionBuilder;
        this.chainedVersionBuilder = chainedVersionBuilder;
    }

    @Override
    public MojangVersion buildVersionFromKey(String key) throws InterruptedException, IOException {
        MojangVersion primary = this.primaryVersionBuilder.buildVersionFromKey(key);
        if (primary == null) {
            return null;
        }
        VersionChain chain = new VersionChain(primary);
        MojangVersion latest = primary;
        while (latest.getParentVersion() != null) {
            if ((latest = this.chainedVersionBuilder.buildVersionFromKey(latest.getParentVersion())) == null) {
                return null;
            }
            chain.addVersionToChain(latest);
        }
        if (latest.getDownloads() == null) {
            String[] parts = latest.getId().split("-");
            if (!MINECRAFT_VERSION_PATTERN.matcher(parts[0]).matches()) {
                throw new IOException("Latest version in version chain failed to resolve to a Minecraft version");
            }
            chain.addVersionToChain(this.chainedVersionBuilder.buildVersionFromKey(parts[0]));
        }
        return chain;
    }
}

