/*
 * Decompiled with CFR 0.152.
 */
package net.technicpack.minecraftcore.mojang.version.io.argument;

import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import java.util.ArrayList;
import net.technicpack.minecraftcore.mojang.version.io.Rule;
import net.technicpack.minecraftcore.mojang.version.io.argument.Argument;
import net.technicpack.minecraftcore.mojang.version.io.argument.ArgumentList;
import net.technicpack.minecraftcore.mojang.version.io.argument.ArgumentStringList;
import net.technicpack.minecraftcore.mojang.version.io.argument.PredicatedArgument;

public class ArgumentListAdapter
implements JsonSerializer<ArgumentList>,
JsonDeserializer<ArgumentList> {
    @Override
    public ArgumentList deserialize(JsonElement json, Type type, JsonDeserializationContext ctx) throws JsonParseException {
        if (!json.isJsonArray()) {
            throw new JsonParseException("Expected argument array, got: " + json);
        }
        ArgumentList.Builder argsBuilder = new ArgumentList.Builder();
        for (JsonElement arg : json.getAsJsonArray()) {
            if (arg.isJsonObject()) {
                Argument argValue;
                JsonObject argObj = arg.getAsJsonObject();
                JsonArray rules = argObj.get("rules").getAsJsonArray();
                ArrayList<Rule> predicates = new ArrayList<Rule>();
                for (JsonElement rule : rules) {
                    predicates.add(new Rule(rule.getAsJsonObject()));
                }
                JsonElement value = argObj.get("value");
                if (value.isJsonArray()) {
                    ArrayList<String> argStrings = new ArrayList<String>();
                    for (JsonElement valueElem : value.getAsJsonArray()) {
                        if (valueElem.isJsonPrimitive() && valueElem.getAsJsonPrimitive().isString()) {
                            argStrings.add(valueElem.getAsString());
                            continue;
                        }
                        throw new JsonParseException("Expected argument string, got: " + arg);
                    }
                    argValue = new ArgumentStringList(argStrings);
                } else if (value.isJsonPrimitive() && value.getAsJsonPrimitive().isString()) {
                    argValue = Argument.literal(value.getAsString());
                } else {
                    throw new JsonParseException("Expected argument literal, got: " + arg);
                }
                argsBuilder.addArgument(new PredicatedArgument(predicates, argValue));
                continue;
            }
            if (arg.isJsonPrimitive() && arg.getAsJsonPrimitive().isString()) {
                argsBuilder.addArgument(Argument.literal(arg.getAsString()));
                continue;
            }
            throw new JsonParseException("Expected argument, got: " + arg);
        }
        return argsBuilder.build();
    }

    @Override
    public JsonElement serialize(ArgumentList args, Type type, JsonSerializationContext ctx) {
        return args.serialize();
    }
}

