/*
 * Decompiled with CFR 0.152.
 */
package net.technicpack.platform;

import java.util.logging.Level;
import net.technicpack.launchercore.modpacks.InstalledPack;
import net.technicpack.launchercore.modpacks.packinfo.CombinedPackInfo;
import net.technicpack.launchercore.modpacks.sources.IAuthoritativePackSource;
import net.technicpack.platform.IPlatformApi;
import net.technicpack.platform.io.PlatformPackInfo;
import net.technicpack.rest.RestfulAPIException;
import net.technicpack.rest.io.PackInfo;
import net.technicpack.solder.ISolderApi;
import net.technicpack.solder.ISolderPackApi;
import net.technicpack.solder.io.SolderPackInfo;
import net.technicpack.utilslib.Utils;

public class PlatformPackInfoRepository
implements IAuthoritativePackSource {
    private IPlatformApi platform;
    private ISolderApi solder;

    public PlatformPackInfoRepository(IPlatformApi platform, ISolderApi solder) {
        this.platform = platform;
        this.solder = solder;
    }

    @Override
    public PackInfo getPackInfo(InstalledPack pack) {
        return this.getPlatformPackInfo(pack.getName());
    }

    @Override
    public PackInfo getCompletePackInfo(PackInfo pack) {
        return this.getPlatformPackInfo(pack.getName());
    }

    protected PackInfo getPlatformPackInfo(String slug) {
        try {
            PlatformPackInfo platformInfo = this.platform.getPlatformPackInfoForBulk(slug);
            PackInfo info = this.getInfoFromPlatformInfo(platformInfo);
            return info;
        }
        catch (RestfulAPIException ex) {
            Utils.getLogger().log(Level.WARNING, "Unable to load platform pack " + slug, ex);
            return null;
        }
    }

    protected PackInfo getInfoFromPlatformInfo(PlatformPackInfo platformInfo) {
        if (platformInfo != null && platformInfo.hasSolder()) {
            try {
                ISolderPackApi solderPack = this.solder.getSolderPack(platformInfo.getSolder(), platformInfo.getName(), this.solder.getMirrorUrl(platformInfo.getSolder()));
                SolderPackInfo solderInfo = solderPack.getPackInfoForBulk();
                if (solderInfo == null) {
                    return platformInfo;
                }
                return new CombinedPackInfo(solderInfo, platformInfo);
            }
            catch (RestfulAPIException ex) {
                Utils.getLogger().log(Level.SEVERE, "Failed to query Solder for modpack " + platformInfo.getName(), ex);
                return platformInfo;
            }
        }
        return platformInfo;
    }
}

