/*
 * Decompiled with CFR 0.152.
 */
package net.technicpack.platform.cache;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.gson.JsonSyntaxException;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.TimeUnit;
import net.technicpack.launchercore.install.LauncherDirectories;
import net.technicpack.platform.IPlatformApi;
import net.technicpack.platform.io.NewsData;
import net.technicpack.platform.io.PlatformPackInfo;
import net.technicpack.rest.RestfulAPIException;
import net.technicpack.utilslib.Utils;
import org.apache.commons.io.FileUtils;

public class ModpackCachePlatformApi
implements IPlatformApi {
    private IPlatformApi innerApi;
    private Cache<String, PlatformPackInfo> cache;
    private Cache<String, Boolean> deadPacks;
    private Cache<String, PlatformPackInfo> foreverCache;
    private LauncherDirectories directories;

    public ModpackCachePlatformApi(IPlatformApi innerApi, int cacheInSeconds, LauncherDirectories directories) {
        this.innerApi = innerApi;
        this.directories = directories;
        this.cache = CacheBuilder.newBuilder().concurrencyLevel(4).maximumSize(300L).expireAfterWrite(cacheInSeconds, TimeUnit.SECONDS).build();
        this.foreverCache = CacheBuilder.newBuilder().concurrencyLevel(4).maximumSize(300L).build();
        this.deadPacks = CacheBuilder.newBuilder().concurrencyLevel(4).maximumSize(300L).expireAfterWrite(cacheInSeconds / 10, TimeUnit.SECONDS).build();
    }

    @Override
    public PlatformPackInfo getPlatformPackInfoForBulk(String packSlug) throws RestfulAPIException {
        PlatformPackInfo info = this.foreverCache.getIfPresent(packSlug);
        if (info == null) {
            info = this.loadForeverCache(packSlug);
        }
        if (info == null && this.isDead(packSlug)) {
            return null;
        }
        if (info == null) {
            info = this.pullAndCache(packSlug);
        }
        return info;
    }

    @Override
    public PlatformPackInfo getPlatformPackInfo(String packSlug) {
        PlatformPackInfo info = this.cache.getIfPresent(packSlug);
        if (info == null && this.isDead(packSlug)) {
            return this.getDeadPackInfo(packSlug);
        }
        try {
            if (info == null) {
                info = this.pullAndCache(packSlug);
            }
        }
        catch (RestfulAPIException ex) {
            ex.printStackTrace();
            this.deadPacks.put(packSlug, true);
            return this.getDeadPackInfo(packSlug);
        }
        return info;
    }

    protected PlatformPackInfo getDeadPackInfo(String packSlug) {
        try {
            PlatformPackInfo deadInfo = this.getPlatformPackInfoForBulk(packSlug);
            if (deadInfo != null) {
                deadInfo.setLocal();
            }
            return deadInfo;
        }
        catch (RestfulAPIException ex) {
            return null;
        }
    }

    private boolean isDead(String packSlug) {
        Boolean isDead = this.deadPacks.getIfPresent(packSlug);
        return isDead != null && isDead != false;
    }

    private PlatformPackInfo pullAndCache(String packSlug) throws RestfulAPIException {
        PlatformPackInfo info = null;
        try {
            info = this.innerApi.getPlatformPackInfoForBulk(packSlug);
            if (info != null) {
                this.cache.put(packSlug, info);
                this.foreverCache.put(packSlug, info);
                this.saveForeverCache(info);
            }
            this.deadPacks.put(packSlug, info == null);
        }
        catch (Throwable throwable) {
            this.deadPacks.put(packSlug, info == null);
            throw throwable;
        }
        return info;
    }

    private PlatformPackInfo loadForeverCache(String packSlug) {
        File cacheFile = new File(new File(new File(this.directories.getAssetsDirectory(), "packs"), packSlug), "cache.json");
        if (!cacheFile.exists()) {
            return null;
        }
        try {
            String packCache = FileUtils.readFileToString(cacheFile, StandardCharsets.UTF_8);
            PlatformPackInfo info = Utils.getGson().fromJson(packCache, PlatformPackInfo.class);
            if (info != null) {
                this.foreverCache.put(packSlug, info);
            }
            return info;
        }
        catch (JsonSyntaxException | IOException ex) {
            return null;
        }
    }

    private void saveForeverCache(PlatformPackInfo info) {
        File cacheFile = new File(new File(new File(this.directories.getAssetsDirectory(), "packs"), info.getName()), "cache.json");
        String packCache = Utils.getGson().toJson(info);
        try {
            FileUtils.writeStringToFile(cacheFile, packCache, StandardCharsets.UTF_8);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public String getPlatformUri(String packSlug) {
        return this.innerApi.getPlatformUri(packSlug);
    }

    @Override
    public void incrementPackRuns(String packSlug) {
        this.innerApi.incrementPackRuns(packSlug);
    }

    @Override
    public void incrementPackInstalls(String packSlug) {
        this.innerApi.incrementPackInstalls(packSlug);
    }

    @Override
    public NewsData getNews() throws RestfulAPIException {
        return this.innerApi.getNews();
    }
}

