/*
 * Decompiled with CFR 0.152.
 */
package net.technicpack.platform.http;

import net.technicpack.platform.IPlatformApi;
import net.technicpack.platform.io.NewsData;
import net.technicpack.platform.io.PlatformPackInfo;
import net.technicpack.rest.RestObject;
import net.technicpack.rest.RestfulAPIException;
import net.technicpack.utilslib.Utils;

public class HttpPlatformApi
implements IPlatformApi {
    private String platformUrl;
    private String launcherBuild;

    public HttpPlatformApi(String rootUrl, String launcherBuild) {
        this.platformUrl = rootUrl;
        this.launcherBuild = launcherBuild;
    }

    @Override
    public String getPlatformUri(String packSlug) {
        return this.platformUrl + "modpack/" + packSlug + "?build=" + this.launcherBuild;
    }

    @Override
    public PlatformPackInfo getPlatformPackInfoForBulk(String packSlug) throws RestfulAPIException {
        return this.getPlatformPackInfo(packSlug);
    }

    @Override
    public PlatformPackInfo getPlatformPackInfo(String packSlug) throws RestfulAPIException {
        String url = this.getPlatformUri(packSlug);
        return RestObject.getRestObject(PlatformPackInfo.class, url);
    }

    @Override
    public void incrementPackRuns(String packSlug) {
        String url = this.platformUrl + "modpack/" + packSlug + "/stat/run?build=" + this.launcherBuild;
        Utils.pingHttpURL(url);
    }

    @Override
    public void incrementPackInstalls(String packSlug) {
        String url = this.platformUrl + "modpack/" + packSlug + "/stat/install?build=" + this.launcherBuild;
        Utils.pingHttpURL(url);
    }

    @Override
    public NewsData getNews() throws RestfulAPIException {
        String url = this.platformUrl + "news?build=" + this.launcherBuild;
        return RestObject.getRestObject(NewsData.class, url);
    }
}

