/*
 * Decompiled with CFR 0.152.
 */
package net.technicpack.solder.http;

import net.technicpack.launchercore.exception.BuildInaccessibleException;
import net.technicpack.rest.RestObject;
import net.technicpack.rest.RestfulAPIException;
import net.technicpack.rest.io.Modpack;
import net.technicpack.solder.ISolderPackApi;
import net.technicpack.solder.io.SolderPackInfo;

public class HttpSolderPackApi
implements ISolderPackApi {
    private final String baseUrl;
    private final String modpackSlug;
    private final String clientId;
    private final String mirrorUrl;

    protected HttpSolderPackApi(String baseUrl, String modpackSlug, String clientId, String mirrorUrl) throws RestfulAPIException {
        if (baseUrl == null) {
            throw new RestfulAPIException(String.format("The Solder base URL for the modpack \"%s\" is null", modpackSlug));
        }
        if (mirrorUrl == null) {
            throw new RestfulAPIException(String.format("The Solder mirror URL for the modpack \"%s\" is null", modpackSlug));
        }
        this.baseUrl = baseUrl.charAt(baseUrl.length() - 1) == '/' ? baseUrl.substring(0, baseUrl.length() - 1) : baseUrl;
        this.modpackSlug = modpackSlug;
        this.clientId = clientId;
        this.mirrorUrl = mirrorUrl;
    }

    @Override
    public String getMirrorUrl() {
        return this.mirrorUrl;
    }

    @Override
    public SolderPackInfo getPackInfoForBulk() throws RestfulAPIException {
        return this.getPackInfo();
    }

    @Override
    public SolderPackInfo getPackInfo() throws RestfulAPIException {
        String packUrl = String.format("%s/modpack/%s?cid=%s", this.baseUrl, this.modpackSlug, this.clientId);
        SolderPackInfo info = RestObject.getRestObject(SolderPackInfo.class, packUrl);
        info.setSolder(this);
        return info;
    }

    @Override
    public Modpack getPackBuild(String build) throws BuildInaccessibleException {
        String url = String.format("%s/modpack/%s/%s?cid=%s", this.baseUrl, this.modpackSlug, build, this.clientId);
        try {
            return RestObject.getRestObject(Modpack.class, url);
        }
        catch (RestfulAPIException e) {
            throw new BuildInaccessibleException(this.modpackSlug, build, e);
        }
    }
}

