/*
 * Decompiled with CFR 0.152.
 */
package net.technicpack.ui;

import java.util.List;
import java.util.Locale;
import javax.swing.JComboBox;
import net.technicpack.launcher.settings.TechnicSettings;
import net.technicpack.ui.lang.ResourceLoader;
import net.technicpack.ui.listitems.LanguageItem;

public class UIUtils {
    private UIUtils() {
    }

    public static void populateLanguageSelector(String defaultLocaleText, JComboBox<LanguageItem> languages, ResourceLoader resources, TechnicSettings settings) {
        languages.addItem(new LanguageItem("default", defaultLocaleText, resources));
        List<Locale> supportedLanguages = resources.getSupportedLanguages();
        for (Locale locale : supportedLanguages) {
            languages.addItem(new LanguageItem(resources.getCodeFromLocale(locale), locale.getDisplayName(locale), resources.getVariant(locale)));
        }
        String settingsLanguageCode = settings.getLanguageCode();
        if (!settingsLanguageCode.equalsIgnoreCase("default")) {
            Locale wantedLocale = resources.getLocaleFromCode(settingsLanguageCode);
            languages.setSelectedItem(wantedLocale);
        }
    }
}

