/*
 * Decompiled with CFR 0.152.
 */
package net.technicpack.ui.components;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Image;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JFrame;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.text.AttributeSet;
import javax.swing.text.DefaultCaret;
import javax.swing.text.Document;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;

public class ConsoleFrame
extends JFrame
implements MouseListener {
    private static final long serialVersionUID = 1L;
    private static String[] monospaceFontNames = new String[]{"Consolas", "DejaVu Sans Mono", "Bitstream Vera Sans Mono", "Lucida Console"};
    private final SimpleAttributeSet highlightedAttributes;
    private final SimpleAttributeSet errorAttributes;
    private final SimpleAttributeSet warnAttributes;
    private final SimpleAttributeSet debugAttributes;
    private final SimpleAttributeSet defaultAttributes = new SimpleAttributeSet();
    private JTextPane textPane;
    private Document document;
    private int numLines;
    private JScrollPane scrollPane;

    public ConsoleFrame(int numLines, Image frameIcon) {
        super("Technic Launcher Console");
        this.setModalExclusionType(Dialog.ModalExclusionType.TOOLKIT_EXCLUDE);
        this.numLines = numLines;
        this.highlightedAttributes = new SimpleAttributeSet();
        StyleConstants.setForeground(this.highlightedAttributes, Color.BLACK);
        StyleConstants.setBackground(this.highlightedAttributes, Color.YELLOW);
        this.errorAttributes = new SimpleAttributeSet();
        StyleConstants.setForeground(this.errorAttributes, new Color(200, 0, 0));
        this.warnAttributes = new SimpleAttributeSet();
        StyleConstants.setForeground(this.warnAttributes, new Color(200, 200, 0));
        this.debugAttributes = new SimpleAttributeSet();
        StyleConstants.setForeground(this.debugAttributes, Color.DARK_GRAY);
        this.setSize(new Dimension(896, 504));
        this.buildUI();
        this.setIconImage(frameIcon);
        this.addMouseListener(this);
        this.setDefaultCloseOperation(1);
    }

    public Document getDocument() {
        return this.document;
    }

    public AttributeSet getHighlightedAttributes() {
        return this.highlightedAttributes;
    }

    public AttributeSet getDefaultAttributes() {
        return this.defaultAttributes;
    }

    public AttributeSet getErrorAttributes() {
        return this.errorAttributes;
    }

    public AttributeSet getWarnAttributes() {
        return this.warnAttributes;
    }

    public AttributeSet getDebugAttributes() {
        return this.debugAttributes;
    }

    public void setCaretPosition(int position) {
        this.textPane.setCaretPosition(position);
    }

    public JTextPane getTextPane() {
        return this.textPane;
    }

    public JScrollPane getScrollPane() {
        return this.scrollPane;
    }

    private void buildUI() {
        this.textPane = new JTextPane();
        this.textPane.addMouseListener(this);
        this.textPane.setFont(ConsoleFrame.getMonospaceFont());
        this.textPane.setEditable(false);
        DefaultCaret caret = (DefaultCaret)this.textPane.getCaret();
        caret.setUpdatePolicy(1);
        this.document = this.textPane.getDocument();
        this.textPane.setBackground(Color.BLACK);
        this.textPane.setForeground(Color.WHITE);
        this.scrollPane = new JScrollPane(this.textPane);
        this.scrollPane.setBorder(null);
        this.scrollPane.setVerticalScrollBarPolicy(22);
        this.add((Component)this.scrollPane, "Center");
    }

    public static Font getMonospaceFont() {
        for (String fontName : monospaceFontNames) {
            Font font = new Font(fontName, 0, 14);
            if (font.getFamily().equalsIgnoreCase("Dialog")) continue;
            return font;
        }
        return new Font("Monospace", 0, 14);
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (e.isPopupTrigger()) {
            this.doPop(e);
        }
    }

    private void doPop(MouseEvent e) {
        if (!e.getComponent().isVisible()) {
            return;
        }
        ContextMenu menu = new ContextMenu();
        menu.show(e.getComponent(), e.getX(), e.getY());
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (e.isPopupTrigger()) {
            this.doPop(e);
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    private class ContextMenu
    extends JPopupMenu {
        private static final long serialVersionUID = 1L;
        JMenuItem copy = new JMenuItem("Copy");
        JMenuItem clear;

        public ContextMenu() {
            this.add(this.copy);
            this.copy.addActionListener(e -> ConsoleFrame.this.textPane.copy());
            this.clear = new JMenuItem("Clear");
            this.add(this.clear);
            this.clear.addActionListener(e -> ConsoleFrame.this.textPane.setText(null));
        }
    }
}

