/*
 * Decompiled with CFR 0.152.
 */
package net.technicpack.ui.controls.feeds;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import javax.swing.BoxLayout;
import javax.swing.JPanel;

public class HorizontalGallery
extends JPanel {
    private int pixelPosition = -8;
    private Component selectedComponent;
    private Component lastDisplayedComponent;
    private Component noComponentsMessage;

    public HorizontalGallery() {
        this.setLayout(new BoxLayout(this, 2));
        this.setOpaque(false);
    }

    public void setNoComponentsMessage(Component noComponentsMessage) {
        this.noComponentsMessage = noComponentsMessage;
    }

    @Override
    public Dimension getMinimumSize() {
        return new Dimension(16, 16);
    }

    @Override
    public void setBounds(int x, int y, int w, int h) {
        super.setBounds(x, y, w, h);
    }

    @Override
    public void doLayout() {
        boolean hasNoComponents;
        super.doLayout();
        boolean bl = hasNoComponents = this.getComponentCount() == 0 || this.getComponentCount() == 1 && this.getComponent(0) == this.noComponentsMessage;
        if (this.noComponentsMessage != null) {
            this.noComponentsMessage.setVisible(hasNoComponents);
            this.remove(this.noComponentsMessage);
            if (hasNoComponents) {
                this.add(this.noComponentsMessage);
            }
        }
        if (!hasNoComponents) {
            int startX = 0 - this.pixelPosition;
            for (Component component : this.getComponents()) {
                Rectangle cBounds = component.getBounds();
                component.setBounds(startX, cBounds.y, cBounds.width, cBounds.height);
                component.invalidate();
                if (startX >= 2 && startX + cBounds.width < this.getWidth()) {
                    this.lastDisplayedComponent = component;
                }
                startX += cBounds.width + 8;
            }
        } else if (this.noComponentsMessage != null) {
            Dimension messageSize = this.noComponentsMessage.getPreferredSize();
            Dimension size = this.getSize();
            this.noComponentsMessage.setBounds((size.width - messageSize.width) / 2, (size.height - messageSize.height) / 2, messageSize.width, messageSize.height);
        }
        this.repaint();
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        g.setColor(this.getBackground());
        ((Graphics2D)g).setPaint(this.getBackground());
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
    }

    @Override
    public void paintChildren(Graphics g) {
        boolean hasNoComponents;
        Graphics2D g2d = (Graphics2D)g;
        Paint oldPaint = g2d.getPaint();
        super.paintChildren(g);
        boolean bl = hasNoComponents = this.getComponentCount() == 0 || this.getComponentCount() == 1 && this.getComponent(0) == this.noComponentsMessage;
        if (!hasNoComponents) {
            g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            Color background = this.getBackground();
            Color flatBackground = new Color(background.getRed(), background.getGreen(), background.getBlue(), 255);
            if (this.getComponentCount() != 0) {
                if (this.getSelectedComponent() != this.getComponent(0)) {
                    g2d.setPaint(new GradientPaint(0.0f, 0.0f, flatBackground, 70.0f, 0.0f, new Color(0, 0, 0, 0)));
                    g2d.fillRect(0, 0, this.getWidth(), this.getHeight());
                }
                if (this.lastDisplayedComponent != this.getComponents()[this.getComponentCount() - 1]) {
                    g2d.setPaint(new GradientPaint(this.getWidth() - 80, 0.0f, new Color(0, 0, 0, 0), this.getWidth() - 10, 0.0f, flatBackground));
                    g2d.fillRect(0, 0, this.getWidth(), this.getHeight());
                }
            }
            g2d.setPaint(oldPaint);
        }
    }

    public Component getSelectedComponent() {
        if (this.getComponentCount() == 0) {
            return null;
        }
        Component first = this.getComponent(0);
        if (!this.containsComponent(this.selectedComponent)) {
            this.internalSelectComponent(first);
        }
        return this.selectedComponent;
    }

    public void selectNextComponent() {
        boolean getNextComponent = false;
        if (this.getComponents()[this.getComponentCount() - 1] == this.lastDisplayedComponent) {
            return;
        }
        for (Component component : this.getComponents()) {
            if (component == this.getSelectedComponent()) {
                getNextComponent = true;
                continue;
            }
            if (!getNextComponent) continue;
            this.internalSelectComponent(component);
            return;
        }
    }

    public void selectPreviousComponent() {
        Component previousComponent = null;
        for (Component component : this.getComponents()) {
            if (component == this.getSelectedComponent() && previousComponent != null) {
                this.internalSelectComponent(previousComponent);
                return;
            }
            previousComponent = component;
        }
    }

    public boolean selectComponent(Component selection) {
        if (!this.containsComponent(selection)) {
            return false;
        }
        boolean isAfterCurrentSelection = true;
        boolean isVisible = false;
        for (Component component : this.getComponents()) {
            if (component == this.getSelectedComponent()) {
                isVisible = true;
            }
            if (component == selection) {
                if (isVisible) break;
                isAfterCurrentSelection = false;
                break;
            }
            if (component != this.lastDisplayedComponent) continue;
            isVisible = false;
            break;
        }
        if (isVisible) {
            return false;
        }
        if (isAfterCurrentSelection) {
            return this.seekForwardToComponent(selection);
        }
        return this.seekBackwardToComponent(selection);
    }

    protected boolean seekForwardToComponent(Component component) {
        Component lastComponent;
        boolean didMoveGallery = false;
        do {
            lastComponent = this.getSelectedComponent();
            this.selectNextComponent();
            if (this.getSelectedComponent() == lastComponent) continue;
            didMoveGallery = true;
        } while (this.getSelectedComponent() != lastComponent && this.getSelectedComponent() != component);
        return didMoveGallery;
    }

    protected boolean seekBackwardToComponent(Component component) {
        Component lastComponent;
        boolean didMoveGallery = false;
        do {
            lastComponent = this.getSelectedComponent();
            this.selectPreviousComponent();
            if (this.getSelectedComponent() == lastComponent) continue;
            didMoveGallery = true;
        } while (this.getSelectedComponent() != lastComponent && this.lastDisplayedComponent != component);
        return didMoveGallery;
    }

    protected void internalSelectComponent(Component selection) {
        if (this.containsComponent(selection)) {
            this.selectedComponent = selection;
            int seekPixel = -8;
            for (Component previousComponent : this.getComponents()) {
                if (previousComponent == selection) break;
                seekPixel += previousComponent.getWidth();
                seekPixel += 8;
            }
            if (seekPixel != -8) {
                seekPixel -= 40;
            }
            this.pixelPosition = seekPixel;
            this.doLayout();
        }
    }

    private boolean containsComponent(Component selection) {
        boolean foundSelected = false;
        for (Component component : this.getComponents()) {
            if (component != selection) continue;
            foundSelected = true;
            break;
        }
        return foundSelected;
    }
}

