/*
 * Decompiled with CFR 0.152.
 */
package net.technicpack.ui.controls.lang;

import java.awt.Color;
import java.awt.Component;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import net.technicpack.launcher.ui.UIConstants;
import net.technicpack.ui.lang.ResourceLoader;
import net.technicpack.ui.listitems.LanguageItem;

public class LanguageCellRenderer
extends JLabel
implements ListCellRenderer<LanguageItem> {
    private ImageIcon globe;
    private final Color defaultBackground;
    private final Color defaultForeground;

    public LanguageCellRenderer(ResourceLoader resourceLoader, String langIcon, Color defaultBackground, Color defaultForeground) {
        if (langIcon != null) {
            this.globe = resourceLoader.getIcon(langIcon);
        }
        this.defaultBackground = defaultBackground;
        this.defaultForeground = defaultForeground;
        this.setForeground(defaultForeground);
        this.setBackground(defaultBackground);
        this.setFont(resourceLoader.getFont("OpenSans+Cyberbit.ttf", 14.0f));
        this.setOpaque(true);
    }

    @Override
    public Component getListCellRendererComponent(JList<? extends LanguageItem> list, LanguageItem value, int index, boolean isSelected, boolean cellHasFocus) {
        this.setForeground(this.defaultForeground);
        this.setBackground(this.defaultBackground);
        this.setFont(value.getLanguageResources().getFont("OpenSans+Cyberbit.ttf", list.getFont().getSize()));
        this.setText(value.toString());
        LanguageItem selectedValue = list.getSelectedValue();
        if (this.globe != null) {
            if (!isSelected && selectedValue != null && selectedValue.equals(value)) {
                this.setIcon(this.globe);
            } else {
                this.setIcon(null);
            }
        }
        if (selectedValue != null && selectedValue.equals(value)) {
            this.setBackground(UIConstants.COLOR_SELECTOR_OPTION);
        } else {
            this.setBackground(this.defaultBackground);
        }
        return this;
    }
}

