/*
 * Decompiled with CFR 0.152.
 */
package net.technicpack.ui.controls.login;

import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyListener;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import javax.swing.BorderFactory;
import javax.swing.ComboBoxEditor;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import net.technicpack.launchercore.auth.IUserType;
import net.technicpack.launchercore.image.IImageJobListener;
import net.technicpack.launchercore.image.ImageJob;
import net.technicpack.launchercore.image.ImageRepository;
import net.technicpack.utilslib.ImageUtils;

public class UserCellEditor
implements ComboBoxEditor,
DocumentListener,
IImageJobListener<IUserType> {
    private Font textFont;
    private static final int ICON_WIDTH = 32;
    private static final int ICON_HEIGHT = 32;
    private JPanel parentPanel;
    private JLabel userLabel;
    private JTextField textField;
    private CardLayout layout;
    private Object currentObject;
    private HashMap<String, Icon> headMap = new HashMap();
    Collection<ActionListener> actionListeners = new HashSet<ActionListener>();
    private ImageRepository<IUserType> mSkinRepo;
    private static final String USER = "user";
    private static final String STRING = "string";

    public UserCellEditor(Font font, ImageRepository<IUserType> skinRepo, Color textColor) {
        this.textFont = font;
        this.mSkinRepo = skinRepo;
        this.layout = new CardLayout();
        this.parentPanel = new JPanel();
        this.parentPanel.setLayout(this.layout);
        this.parentPanel.setOpaque(false);
        this.userLabel = new JLabel();
        this.userLabel.setOpaque(false);
        this.userLabel.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        this.userLabel.setFont(this.textFont);
        this.userLabel.setForeground(textColor);
        this.parentPanel.add((Component)this.userLabel, USER);
        this.textField = new JTextField();
        this.textField.setOpaque(false);
        this.textField.setFont(this.textFont);
        this.textField.setBorder(null);
        this.textField.setForeground(textColor);
        this.textField.getDocument().addDocumentListener(this);
        this.textField.setCaretColor(textColor);
        this.parentPanel.add((Component)this.textField, STRING);
    }

    @Override
    public Component getEditorComponent() {
        return this.parentPanel;
    }

    @Override
    public void setItem(Object anObject) {
        this.currentObject = anObject;
        if (anObject instanceof IUserType) {
            IUserType user = (IUserType)anObject;
            this.userLabel.setText(user.getDisplayName());
            this.userLabel.setIconTextGap(8);
            if (!this.headMap.containsKey(user.getUsername())) {
                ImageJob<IUserType> job = this.mSkinRepo.startImageJob(user);
                job.addJobListener(this);
                this.headMap.put(user.getUsername(), new ImageIcon(ImageUtils.scaleImage(job.getImage(), 32, 32)));
            }
            Icon head = this.headMap.get(user.getUsername());
            this.userLabel.setIcon(head);
            this.layout.show(this.parentPanel, USER);
        } else {
            String newText = "";
            if (anObject != null) {
                newText = anObject.toString();
            }
            if (!this.textField.getText().equals(newText)) {
                this.textField.setText(newText);
            }
            this.layout.show(this.parentPanel, STRING);
            this.textField.requestFocus();
        }
    }

    @Override
    public Object getItem() {
        return this.currentObject;
    }

    @Override
    public void selectAll() {
    }

    @Override
    public void addActionListener(ActionListener l) {
        this.actionListeners.add(l);
    }

    @Override
    public void removeActionListener(ActionListener l) {
        this.actionListeners.remove(l);
    }

    public void addKeyListener(KeyListener k) {
        this.userLabel.addKeyListener(k);
    }

    public void removeKeyListener(KeyListener k) {
        this.userLabel.removeKeyListener(k);
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.currentObject = this.textField.getText();
        for (ActionListener listener : this.actionListeners) {
            listener.actionPerformed(new ActionEvent(this, 0, "edited"));
        }
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.currentObject = this.textField.getText();
        for (ActionListener listener : this.actionListeners) {
            listener.actionPerformed(new ActionEvent(this, 0, "edited"));
        }
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        this.currentObject = this.textField.getText();
        for (ActionListener listener : this.actionListeners) {
            listener.actionPerformed(new ActionEvent(this, 0, "edited"));
        }
    }

    @Override
    public void jobComplete(ImageJob<IUserType> job) {
        IUserType user = job.getJobData();
        this.headMap.put(user.getUsername(), new ImageIcon(ImageUtils.scaleImage(job.getImage(), 32, 32)));
        this.parentPanel.revalidate();
    }
}

