/*
 * Decompiled with CFR 0.152.
 */
package net.technicpack.ui.controls.login;

import java.awt.Component;
import java.util.HashMap;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import net.technicpack.launchercore.auth.IUserType;
import net.technicpack.launchercore.image.IImageJobListener;
import net.technicpack.launchercore.image.ImageJob;
import net.technicpack.launchercore.image.ImageRepository;
import net.technicpack.ui.controls.list.AdvancedCellRenderer;
import net.technicpack.ui.lang.ResourceLoader;
import net.technicpack.utilslib.ImageUtils;

public class UserCellRenderer
extends AdvancedCellRenderer<IUserType>
implements ListCellRenderer<IUserType>,
IImageJobListener<IUserType> {
    private Icon addUserIcon;
    private ImageRepository<IUserType> mSkinRepo;
    private static final int ICON_WIDTH = 32;
    private static final int ICON_HEIGHT = 32;
    private HashMap<String, Icon> headMap = new HashMap();

    public UserCellRenderer(ResourceLoader resources, ImageRepository<IUserType> skinRepo) {
        this.mSkinRepo = skinRepo;
        this.addUserIcon = resources.getIcon("add_user.png");
    }

    @Override
    public Component getListCellRendererComponent(JList<? extends IUserType> list, IUserType user, int index, boolean isSelected, boolean cellHasFocus) {
        Icon head;
        super.getListCellRendererComponent(list, user, index, isSelected, cellHasFocus);
        if (!this.headMap.containsKey(user.getUsername())) {
            ImageJob<IUserType> job = this.mSkinRepo.startImageJob(user);
            job.addJobListener(this);
            this.headMap.put(user.getUsername(), new ImageIcon(ImageUtils.scaleImage(job.getImage(), 32, 32)));
        }
        if ((head = this.headMap.get(user.getUsername())) != null) {
            this.setIcon(head);
        }
        return this;
    }

    @Override
    public void jobComplete(ImageJob<IUserType> job) {
        IUserType user = job.getJobData();
        this.headMap.remove(user.getUsername());
        this.headMap.put(user.getUsername(), new ImageIcon(ImageUtils.scaleImage(job.getImage(), 32, 32)));
        this.invalidate();
    }
}

